#ifndef _VERTEXONEDGE_H_
#define _VERTEXONEDGE_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../include/typedefs.h"
#include "../include/macros.h"
#include "MeshVertex.h"
#include "Edge.h"

namespace bamg {

	//classes
	class Triangles;

	class VertexOnEdge {

		public:
			MeshVertex* v;
			Edge*   be;
			double abcisse;

			//Constructors
			VertexOnEdge( MeshVertex * w, Edge *bw,double s) :v(w),be(bw),abcisse(s) {}
			VertexOnEdge(){}

			//Operators
			operator double () const { return abcisse;}
			operator MeshVertex* () const { return v;}  
			operator Edge* () const { return be;}  
			MeshVertex & operator[](int i) const { return (*be)[i];}

			//Methods
			void SetOnBTh(){v->onBackgroundEdge=this;v->vint=IsVertexOnEdge;}  
			void Set(const Triangles &,long,Triangles &);  
	};

}
#endif
