#ifndef _VERTEX_H_
#define _VERTEX_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../include/typedefs.h"
#include "../include/macros.h"
#include "Direction.h"
#include "Metric.h"

namespace bamg {

	//classes
	class Triangle;
	class Triangles;
	class VertexOnGeom;
	class VertexOnEdge;

	class MeshVertex {

		public:
			I2 i;  // integer coordinates
			R2 r;  // real coordinates
			Metric m;
			long ReferenceNumber;
			Direction DirOfSearch;
			short vint;  // the vertex number in triangle; varies between 0 and 2 in t
			union {
				Triangle* t;   // one triangle which is containing the vertex
				long      color;
				MeshVertex*   to;  // used in geometry MeshVertex to know the Mesh MeshVertex associated 
				VertexOnGeom* onGeometry;        // if vint == 8; // set with Triangles::SetVertexFieldOn()
				MeshVertex*       onBackgroundVertex;// if vint == 16 on Background vertex Triangles::SetVertexFieldOnBTh()
				VertexOnEdge* onBackgroundEdge;  // if vint == 32 on Background edge
			};

			//Operators
			operator I2() const {return i;}             // Cast operator
			operator const R2 & () const {return r;}    // Cast operator
			operator Metric () const {return m;}        // Cast operator
			double operator()(R2 x) const { return m(x);} // Get x in the metric m

			//methods (No constructor and no destructors...)
			double Smoothing(Triangles & ,const Triangles & ,Triangle  * & ,double =1);
			void   MetricFromHessian(const double Hxx,const double Hyx, const double Hyy, const double smin,const double smax,const double s,const double err,BamgOpts* bamgopts);
			void   Echo();
			int    ref() const { return ReferenceNumber;}
			long   Optim(int =1,int =0); 

			//inline functions
			inline void Set(const MeshVertex &rec,const Triangles & ,Triangles & ){*this=rec;}
	};

	//Intermediary
	double QuadQuality(const MeshVertex &,const MeshVertex &,const MeshVertex &,const MeshVertex &);
}
#endif
