function varargout = data_processing_tool(varargin)
%DATA_PROCESSING_TOOL - GUI to process binary data
%
%   this routine is a GUI that helps the user to open
%   a binary file (Little Endian, Big Endian, Float 32,
%   double,...) and save a Matlab file (.mat) with the
%   processed data and the coordinates
%
%   Usage:
%      data_processing_tool

	gui_Singleton = 1;
	gui_State = struct('gui_Name',       mfilename, ...
		'gui_Singleton',  gui_Singleton, ...
		'gui_OpeningFcn', @data_processing_tool_OpeningFcn, ...
		'gui_OutputFcn',  @data_processing_tool_OutputFcn, ...
		'gui_LayoutFcn',  [] , ...
		'gui_Callback',   []);
	if nargin && ischar(varargin{1})
		gui_State.gui_Callback = str2func(varargin{1});
	end

	if nargout
		[varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
	else
		gui_mainfcn(gui_State, varargin{:});
	end
end

function data_processing_tool_OpeningFcn(hObject, eventdata, handles, varargin)
	handles.output = hObject;

	%enable toolbar (useful for caxis...)
	set(hObject,'toolbar','figure');

	% Update handles structure
	guidata(hObject, handles);

	%this variable used to prevent users from breaking the GUI
	%the variable is set to 1 once the data has been processed
	handles.processDataCompleted=0;

	%initialize other variables
	handles.Msize=NaN;
	handles.Nsize=NaN;
	handles.numvectors=NaN;
	handles.endian=NaN;
	handles.datatype=NaN;
	handles.dx=NaN;
	handles.dy=NaN;
	handles.xEast=NaN;
	handles.yNorth=NaN;

	%two files permitted
	set(handles.inputFile,'Max',1);
	set(handles.inputFile,'Min',0);

	% Update handles structure
	guidata(hObject, handles);
end

% --- Outputs from this function are returned to the command line.
function varargout = data_processing_tool_OutputFcn(hObject, eventdata, handles) 

	% Get default command line output from handles structure
	varargout{1} = handles.output;
end


function inputFile_Callback(hObject, eventdata, handles)
%no code needed for this callback, the listbox is only used as a visual
end

function addFiles_pushbutton_Callback(hObject, eventdata, handles)
	%gets input file(s) from user. the sample data files have extension .s2p
	[input_file,pathname] = uigetfile( ...
		{'*.*', 'All Files (*.*)'}, ...
		'Select files', ... 
		'MultiSelect', 'on');

	%if file selection is cancelled, pathname should be zero
	%and nothing should happen
	if pathname==0
		return
	end

	handles.processDataCompleted=1;

	%gets the current data file names inside the listbox
	inputFileName=get(handles.inputFile,'String');

	%if they only select one file, then the data will not be a cell
	inputFileName= fullfile(pathname,input_file);

	%updates the gui to display all filenames in the listbox
	set(handles.inputFile,'String',inputFileName);

	%make sure first file is always selected so it doesn't go out of range
	%the GUI will break if this value is out of range
	set(handles.inputFile,'Value',1);

	% Update handles structure
	guidata(hObject, handles);
end

function reset_pushbutton_Callback(hObject, eventdata, handles)
	%resets the GUI by clearing all relevant fields

	handles.processDataCompleted = 0;

	%clears the axes
	cla(handles.axes1,'reset');

	%set the popupmenu to default value
%	set(handles.plot_popupmenu,'Value',1);

	%clears the contents of the listbox
	set(handles.inputFile,'String','');
	set(handles.inputFile,'Value',0);

	%updates the handles structure
	guidata(hObject, handles);
end

function plotdata_pushbutton_Callback(hObject, eventdata, handles)

	%get the list of input file names from the listbox
	inputFileName=get(handles.inputFile,'String');

	%checks to see if the user selected any input files
	%if not, nothing happens
	if isempty(inputFileName)
		errordlg('Select a file first!')
		return
	end

	%disables the button while data is processing
	disableButtons(handles);
	refresh(data_processing_tool); 

	%parse options
	if ~isnan(handles.Msize)
		M=handles.Msize;
	else
		errordlg('Number of lines (M) not valid')
		return
	end
	if ~isnan(handles.Nsize)
		N=handles.Nsize;
	else
		errordlg('Number of rows (N) not valid')
		return
	end
	if ~isnan(handles.numvectors)
		numvectors=handles.numvectors;
		%change M
		M=numvectors*M;
	else
		numvectors=1;
	end
	if ~isnan(handles.endian)
		endian=handles.endian;
	else
		endian=1;
	end
	if ~isnan(handles.datatype)
		datatype=handles.datatype;
	else
		datatype='float32';
	end

	%open file
	if endian==1
		fid=fopen(inputFileName,'r','ieee-be');
	else
		fid=fopen(inputFileName,'r','ieee-le');
	end

	%read file
	[u, numpoints]=fread(fid, [M,N],datatype);

	%close file
	fclose(fid);

	%Pair of vectors?
	if numvectors==2,
	   vx=u(1:2:M,:);vx=flipud(vx');
	   vy=u(2:2:M,:);vx=flipud(vx');

		%keep track
		handles.vx=vx;
		handles.vy=vy;

		u=sqrt(vx.^2+vy.^2);
	end

	cla(handles.axes1); %clear the axes
	axes(handles.axes1); %set the axes to plot
	grid on
	imagesc(u)
	colorbar

	%keep track
	handles.u=u;

	%to see whether the data has been processed or not
	handles.processDataCompleted=2;

	%data is done processing, so re-enable the buttons
	enableButtons(handles);
	guidata(hObject, handles);
end

function plotcoord_Callback(hObject, eventdata, handles)

	%check
	if handles.processDataCompleted<2
		errordlg('Process data first !')
		return
	end

	%parse options
	if ~isnan(handles.dx)
		dx=handles.dx;
	else
		errordlg('value of x-spacing not supported')
		return
	end
	if ~isnan(handles.dy)
		dy=handles.dy;
	else
		errordlg('value of y-spacing not supported')
		return
	end
	if ~isnan(handles.xEast)
		xEast=handles.xEast;
	else
		errordlg('value of xEast not supported')
		return
	end
	if ~isnan(handles.yNorth)
		yNorth=handles.yNorth;
	else
		errordlg('value of yNorth not supported')
		return
	end

	disableButtons(handles);

	%process coordinates
	u=handles.u;
	s=size(u);
	M=s(1)+1;
	N=s(2)+1;

	%correction North and East -> real
	yNorth=yNorth-M*dy; % corner north
	x_m=xEast+dx*(0:N-1)';
	y_m=yNorth+dy*(0:M-1)';

	%plot new axes
	cla(handles.axes1); %clear the axes
	axes(handles.axes1); %set the axes to plot
	grid on
	imagesc(x_m,y_m,handles.u)
	set(handles.axes1,'Ydir','Normal');
	colorbar

	%Keep track of x_m and y_m
	handles.x_m=x_m;
	handles.y_m=y_m;

	%to see whether the data has been processed or not
	handles.processDataCompleted=3;

	%data is done processing, so re-enable the buttons
	enableButtons(handles);
	guidata(hObject, handles);

end


function save_pushbutton_Callback(hObject, eventdata, handles)
	%if the data hasn't been processed yet, 
	%nothing happens when this button is pressed
	if (handles.processDataCompleted ~= 3)
		return
	end

	disableButtons(handles);

	if handles.numvectors==2,

		prompt={'Enter the name of the variable 1:','Enter the name of the variable 2:','Enter the name of the file:'};
		name='Save Matlab File';
		numlines=1;
		defaultanswer={'vx','vy','ProcessedFile'};
		answer=inputdlg(prompt,name,numlines,defaultanswer);
		variablename1=answer{1};
		variablename2=answer{2};
		filename=answer{3};

		if ~isempty(variablename1) & ~isempty(variablename2) & ~isempty(filename)
			%get the variables
			x_m=handles.x_m;
			y_m=handles.y_m;
			eval([variablename1 ' = handles.vx;']);
			eval([variablename2 ' = handles.vy;']);
			x_m=handles.x_m;
			eval(['save ' filename ' x_m y_m ' variablename1 ' ' variablename2 ]);
			disp(['in the file ' filename ' have been saved the following variables: x_m, y_m, ' variablename1 ' and ' variablename2])
		end
	else
		prompt={'Enter the name of the variable:','Enter the name of the file:'};
		name='Save Matlab File';
		numlines=1;
		defaultanswer={'thickness','ProcessedFile'};
		answer=inputdlg(prompt,name,numlines,defaultanswer);
		variablename=answer{1};
		filename=answer{2};

		if ~isempty(variablename) & ~isempty(filename)
			%get the variables
			x_m=handles.x_m;
			y_m=handles.y_m;
			eval([variablename ' = handles.u;']);
			eval(['save ' filename ' x_m y_m ' variablename]);
			disp(['in the file ' filename ' have been saved the following variables: x_m, y_m, and ' variablename])
		end
	end
	enableButtons(handles);
	guidata(hObject, handles);
end

function inputFile_CreateFcn(hObject, eventdata, handles)
	if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
		set(hObject,'BackgroundColor','white');
	end
end

function disableButtons(handles)
	set(handles.figure1,'Pointer','watch');
	set(handles.plotdata_pushbutton,'Enable','off');
	set(handles.plotcoord,'Enable','off');
	set(handles.save_pushbutton,'Enable','off');
	set(handles.addFiles_pushbutton,'Enable','off');
	set(handles.reset_pushbutton,'Enable','off');
end

function enableButtons(handles)
	set(handles.figure1,'Pointer','arrow');
	set(handles.plotdata_pushbutton,'Enable','on');
	set(handles.plotcoord,'Enable','on');
	set(handles.save_pushbutton,'Enable','on');
	set(handles.addFiles_pushbutton,'Enable','on');
	set(handles.reset_pushbutton,'Enable','on');
end

function EndianType_Callback(hObject, eventdata, handles)
	handles.endian=get(handles.EndianType,'Value');
	guidata(hObject, handles);
end

function EndianType_CreateFcn(hObject, eventdata, handles)
	if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
		set(hObject,'BackgroundColor','white');
	end
end

function DataType_Callback(hObject, eventdata, handles)

	datatype= get(handles.DataType,'Value');
	switch datatype
		case 1
			string='float32';

		case 2
			string='single';

		case 3
			string='float64';

		case 4
			string='double';
		end
	handles.datatype=string;
	guidata(hObject, handles);
end

function DataType_CreateFcn(hObject, eventdata, handles)
	if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
		set(hObject,'BackgroundColor','white');
	end
end

function PairOfVectors_Callback(hObject, eventdata, handles)
	handles.numvectors = get(handles.PairOfVectors,'Value');
	guidata(hObject, handles);
end

function PairOfVectors_CreateFcn(hObject, eventdata, handles)
	if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
		set(hObject,'BackgroundColor','white');
	end
end

function Msize_Callback(hObject, eventdata, handles)
	handles.Msize=eval(get(hObject,'String'));
	guidata(hObject, handles);
end

function Msize_CreateFcn(hObject, eventdata, handles)
	if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
		set(hObject,'BackgroundColor','white');
	end
end

function Nsize_Callback(hObject, eventdata, handles)
	handles.Nsize=eval(get(hObject,'String'));
	guidata(hObject, handles);
end

function Nsize_CreateFcn(hObject, eventdata, handles)
	if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
		set(hObject,'BackgroundColor','white');
	end
end

function dx_Callback(hObject, eventdata, handles)
	handles.dx=eval(get(hObject,'String'));
	guidata(hObject, handles);
end
function dx_CreateFcn(hObject, eventdata, handles)
	if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
		set(hObject,'BackgroundColor','white');
	end
end

function dy_Callback(hObject, eventdata, handles)
	handles.dy=eval(get(hObject,'String'));
	guidata(hObject, handles);
end
function dy_CreateFcn(hObject, eventdata, handles)
	if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
		set(hObject,'BackgroundColor','white');
	end
end

function xEast_Callback(hObject, eventdata, handles)
	handles.xEast=eval(get(hObject,'String'));
	guidata(hObject, handles);
end
function xEast_CreateFcn(hObject, eventdata, handles)
	if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
		set(hObject,'BackgroundColor','white');
	end
end

function yNorth_Callback(hObject, eventdata, handles)
	handles.yNorth=eval(get(hObject,'String'));
	guidata(hObject, handles);
end
function yNorth_CreateFcn(hObject, eventdata, handles)
	if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
		set(hObject,'BackgroundColor','white');
	end
end
