%
%  function to return the string dimension of an array element
%
%  function [sdim]=string_dim(a,idim)
%
function [sdim]=string_dim(a,idim)

if ~nargin
    help string_dim
    return
end

if (numel(a) == 1) && (idim == 1)
    sdim='';
    return
end
if (idim > numel(a))
    error('Index %d exceeds number of elements in ''%s''.',...
        idim,inputname(1));
end

asize=size(a);
index=zeros(size(asize));
aprod=prod(asize);
idim =idim-1;

%  calculate indices base 0 and convert to base 1

for i=length(asize):-1:1
    aprod=aprod/asize(i);
    index(i)=floor(idim/aprod);
    idim=idim-index(i)*aprod;
end
index=index+1;

%  assemble string for output

sdim ='(';
for i=1:length(asize)-1;
    sdim =[sdim num2str(index(i)) ','];
end
sdim =[sdim num2str(index(end)) ')'];

end

