function [x_m2 y_m2 values2]=addtrack(x_m1,y_m1,values1,track_coord,track_values,distance,exponent),
%ADDTRACK - modify a map to take values of a track
%
%   This routine modify a map to improve it with values of tracks.
%   This output map has more values than the input one so that the values
%   of the tracks are relevant.
%   x_m1 and y_m1 are two vector containing the coordinates of the matrix
%   the distance between two points must be the same everywhere
%   values1 is a matrix of size (y_m1-1)*(x_m1-1)
%   trac_coord is an exp file containing the coordinates of the tracks (x and y)
%   trav_values is a vector with the values along the track coordinates
%   distance indicates the distance from the tracks where points have to be modified
%   exposant allows to chance the influence of the track and the map
%   it must be positive and usually is superior to 1.
%
%   Usage:
%      [x_m2 y_m2 values1 values2]=addtrack(x_m1,y_m1,values1,track_coord,track_values,distance,exposant)
%
%   Example:
%      [xnew ynew valuesnew]=addtrack(x_m,y_m,thickness,'trackcoord.exp',thickness_track,1000,2)

%Create a new picture precise enough to be modified by the tracks
%Read the points of the tracks
stru=expread(track_coord,1);
nods=stru.nods;
xtracks=stru.x';
ytracks=stru.y';

%First check that the parameters are ok:
if (size(track_values,1)~=nods)  || (size(xtracks,2)~=nods) || (size(ytracks,2)~=nods),
	error('addtrack error message : track coordinates and track values must have the same size');
elseif distance<0,
	error('addtrack error message : the distance must be a positive value');
elseif exponent<0,
	error('addtrack error message : the exponent must be a positive value');
elseif (size(x_m1,1)~=(size(values1,2)+1)) || (size(y_m1,1)~=(size(values1,1)+1)),
	error('addtrack error message : problem in the map, check the size of x_m1, y_m1 and values1');
end

%stru.nods=4;
%xtracks=[50 50 55 62]; % 2 3 4 5 6 7 8 9 1 ]';
%ytracks=[40 40.5 41 41]; % 5 5 5 5 5 5 5 5 8 ]';
%x_m1=[1:10:101]';
%y_m1=[1:10:101]';
%track_values=2*ones(4,1);
%values1=ones(10,10);

%Find the average distance between two points of the tracks
av_x=sum(abs(diff(xtracks)))/(stru.nods-1);
av_y=sum(abs(diff(ytracks)))/(stru.nods-1);
dist_av=sqrt(av_x^2+av_y^2);

%Calculate the multiplicate factor for the new values:
mult=round((x_m1(2)-x_m1(1))/(1*dist_av));

%Plug the values in the new multiplied matrix
values=zeros(mult*size(values1,1),mult*size(values1,2));

for i=1:mult,
	for j=1:mult,
		values(i:mult:end,j:mult:end)=values1;
	end
end

%Create the new x and y addapted to the matrix
x_m2=linspace(x_m1(1),x_m1(end),mult*(size(x_m1,1)-1)+1)';
y_m2=linspace(y_m1(1),y_m1(end),mult*(size(y_m1,1)-1)+1)';

%Create a new set of x and y correponding to the medium value on the matrix
x_med=(x_m2(1:end-1)+x_m2(2:end))/2;
y_med=(y_m2(1:end-1)+y_m2(2:end))/2;

numrow=size(y_med,1);
numcol=size(x_med,1);

%Create new x and y to have the hole matrix
x_mat=repmat(x_med',numrow,1);
y_mat=repmat(y_med,1,numcol);

%Remove useless points of the track
points=find(track_values==0);
track_values(points)=[];
xtracks(points)=[];
ytracks(points)=[];
points=find(isnan(track_values));
track_values(points)=[];
xtracks(points)=[];
ytracks(points)=[];

%Remove points outside of the map
points=find(xtracks<x_med(1) | xtracks>x_med(end) | ytracks<y_med(1) | ytracks>y_med(end));
track_values(points)=[];
xtracks(points)=[];
ytracks(points)=[];

%initialize some matrices
numoverlap=zeros(numrow,numcol);
weights=zeros(numrow,numcol);
weightsvalues=zeros(numrow,numcol);

%Loop over the points of the track
nel=size(track_values,1);
for i=1:nel;
	if mod(i,1000)==0,
		disp(sprintf('\r%s%.2f%s','      track processing progress  ',i/nel*100,' %'));
	end

	x=xtracks(i);
	y=ytracks(i);

	%get indices that are modified
	indexx1=max(find(x_med<x-distance));
	if isempty( indexx1), indexx1=1; end
	indexx2=min(find(x_med>x+distance));
	if isempty( indexx2), indexx2=numrow; end
	indexy1=max(find(y_med<y-distance));
	if isempty( indexy1), indexy1=1; end
	indexy2=min(find(y_med>y+distance));
	if isempty( indexy2), indexy2=numcol; end


	%get weighing coefficient
	val=track_values(i);
	distances=sqrt((x-x_mat(indexy1:indexy2,indexx1:indexx2)).^2+(y-y_mat(indexy1:indexy2,indexx1:indexx2)).^2);
	coeff=min(1,(distances/distance)).^(1/exponent);

	%update numoverlap and weights
	numoverlap(indexy1:indexy2,indexx1:indexx2)=numoverlap(indexy1:indexy2,indexx1:indexx2)+1;
	weights(indexy1:indexy2,indexx1:indexx2)=weights(indexy1:indexy2,indexx1:indexx2)+coeff;
	weightsvalues(indexy1:indexy2,indexx1:indexx2)=weightsvalues(indexy1:indexy2,indexx1:indexx2)+(1-coeff)*val;

end
if nel>1000,
	disp(sprintf('\r%s%.2f%s','      track processing progress:  ',100,' %'));
end


%Change the values of numoverlap to 1 if 0 since we are going to devide by this matrix
numoverlap(find(~numoverlap))=1;

%Same thing for weights since values far from the tracks don't change
weights(find(~weights))=1;

%Create the final matrix depending on the previous matrix
values=(values.*weights+weightsvalues)./numoverlap;

%Plug the values of the track in the new matrix
values2=values;
