#ifndef _EDGE_H_
#define _EDGE_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../include/typedefs.h"
#include "../include/macros.h"
#include "BamgVertex.h"
#include "TriangleAdjacent.h"

namespace bamg {

	//classes
	class Triangles;
	class GeometricalEdge;

	class Edge {

		public:
			Vertex* v[2];
			long ref;
			GeometricalEdge* onGeometry;
			Edge* adj[2]; // the 2 adj edges if on the same curve 

			//Operators
			Vertex & operator[](int i){return *v[i];};
			Vertex * operator()(int i){return v[i];};
			R2       operator()(double t) const; // return the point 
			const Vertex & operator[](int i) const { return *v[i];};

			//Methods
			void ReNumbering(Vertex *vb,Vertex *ve, long *renu){
				if (v[0] >=vb && v[0] <ve) v[0] = vb + renu[v[0]-vb];
				if (v[1] >=vb && v[1] <ve) v[1] = vb + renu[v[1]-vb];
			}
			int Intersection(const  Edge & e) const { 
				if (!(adj[0]==&e || adj[1]==&e)){
					ISSMERROR(exprintf("Intersection bug"));
				}
				if (adj[0]!=&e && adj[1]!=&e){
					ISSMERROR(exprintf("adj[0]!=&e && adj[1]!=&e"));
				}
				return adj[0]==&e ? 0 : 1;
			}
			void Set(const Triangles &,long,Triangles &);

	};
}
#endif

