#ifndef _TRIANGLE_H_
#define _TRIANGLE_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../include/typedefs.h"
#include "../include/macros.h"
#include "BamgVertex.h"
#include "TriangleAdjacent.h"

namespace bamg {

	//classes
	class Triangles;

	class Triangle {

		friend class TriangleAdjacent;

		private:
			Vertex*   TriaVertices[3];      // 3 vertices if t is triangle, t[i] allowed by access function, (*t)[i] if pointer
			Triangle* TriaAdjTriangles[3];  // 3 pointers toward the adjacent triangles
			short     TriaAdjSharedEdge[3]; // number of the edges in the adjacent triangles the edge number 1 is the edge number TriaAdjSharedEdge[1] in the Adjacent triangle 1

		public: 
			Icoor2 det; // determinant du triangle (2 fois l aire des vertices entieres)
			union { 
				Triangle * link ;
				long color;
			};

			//Constructors/Destructors
			Triangle() {}
			Triangle(Triangles *Th,long i,long j,long k);
			Triangle(Vertex *v0,Vertex *v1,Vertex *v2);

			//Operators
			const Vertex & operator[](int i) const {return *TriaVertices[i];};
			Vertex & operator[](int i)  {return *TriaVertices[i];};
			const Vertex * operator()(int i) const {return TriaVertices[i];};
			Vertex * & operator()(int i)  {return TriaVertices[i];};

			//Methods
			void   Echo();
			int    swap(short a1,int=0);
			long   Optim(short a,int =0);
			int    Locked(int a)const { return TriaAdjSharedEdge[a]&4;} 
			int    Hidden(int a)const { return TriaAdjSharedEdge[a]&16;} 
			int    GetAllflag(int a){return TriaAdjSharedEdge[a] & 1020;}
			void   SetAllFlag(int a,int f){TriaAdjSharedEdge[a] = (TriaAdjSharedEdge[a] &3) + (1020 & f);}
			double QualityQuad(int a,int option=1) const;
			short  NuEdgeTriangleAdj(int i) const {return TriaAdjSharedEdge[i&3]&3;} // Number of the  adjacent edge in adj tria  
			TriangleAdjacent FindBoundaryEdge(int i) const;
			TriangleAdjacent Adj(int i)  const {return TriangleAdjacent(TriaAdjTriangles[i],TriaAdjSharedEdge[i]&3);};
			Triangle* TriangleAdj(int i) const {return TriaAdjTriangles[i&3];}
			Triangle* Quadrangle(Vertex * & v0,Vertex * & v1,Vertex * & v2,Vertex * & v3) const ;
			void  ReNumbering(Triangle *tb,Triangle *te, long *renu){
				if (link  >=tb && link  <te) link  = tb + renu[link -tb];
				if (TriaAdjTriangles[0] >=tb && TriaAdjTriangles[0] <te) TriaAdjTriangles[0] = tb + renu[TriaAdjTriangles[0]-tb];
				if (TriaAdjTriangles[1] >=tb && TriaAdjTriangles[1] <te) TriaAdjTriangles[1] = tb + renu[TriaAdjTriangles[1]-tb];
				if (TriaAdjTriangles[2] >=tb && TriaAdjTriangles[2] <te) TriaAdjTriangles[2] = tb + renu[TriaAdjTriangles[2]-tb];    
			}
			void ReNumbering(Vertex *vb,Vertex *ve, long *renu){
				if (TriaVertices[0] >=vb && TriaVertices[0] <ve) TriaVertices[0] = vb + renu[TriaVertices[0]-vb];
				if (TriaVertices[1] >=vb && TriaVertices[1] <ve) TriaVertices[1] = vb + renu[TriaVertices[1]-vb];
				if (TriaVertices[2] >=vb && TriaVertices[2] <ve) TriaVertices[2] = vb + renu[TriaVertices[2]-vb];    
			}
			void SetAdjAdj(short a){
				a &= 3;
				register Triangle *tt=TriaAdjTriangles[a];
				TriaAdjSharedEdge [a] &= 55; // remove MarkUnSwap
				register short aatt = TriaAdjSharedEdge[a] & 3;
				if(tt){ 
					tt->TriaAdjTriangles[aatt]=this;
					tt->TriaAdjSharedEdge[aatt]=a + (TriaAdjSharedEdge[a] & 60 ) ;}// Copy all the mark 
			  }
			void SetAdj2(short a,Triangle *t,short aat){
				TriaAdjTriangles[a]=t;    //the adjacent triangle to the edge a is t
				TriaAdjSharedEdge[a]=aat; //position of the edge in the adjacent triangle
				if(t) { //if t!=NULL add adjacent triangle to t (this)
					t->TriaAdjTriangles[aat]=this;
					t->TriaAdjSharedEdge[aat]=a;
				}
			}
			void SetTriangleContainingTheVertex() { 
				if (TriaVertices[0]) (TriaVertices[0]->t=this,TriaVertices[0]->vint=0);
				if (TriaVertices[1]) (TriaVertices[1]->t=this,TriaVertices[1]->vint=1);
				if (TriaVertices[2]) (TriaVertices[2]->t=this,TriaVertices[2]->vint=2);
			}
			void SetHidden(int a){
				//Get Adjacent Triangle number a
				register Triangle* t = TriaAdjTriangles[a];
				//if it exist
				//C|=D -> C=(C|D) bitwise inclusive OR
				if(t) t->TriaAdjSharedEdge[TriaAdjSharedEdge[a] & 3] |=16;
				TriaAdjSharedEdge[a] |= 16;
			}

			void SetLocked(int a){
				//mark the edge as on Boundary
				register Triangle * t = TriaAdjTriangles[a];
				t->TriaAdjSharedEdge[TriaAdjSharedEdge[a] & 3] |=4;
				TriaAdjSharedEdge[a] |= 4;
			}
			void SetMarkUnSwap(int a){
				register Triangle * t = TriaAdjTriangles[a];
				t->TriaAdjSharedEdge[TriaAdjSharedEdge[a] & 3] |=8;
				TriaAdjSharedEdge[a] |=8 ;
			}
			void SetUnMarkUnSwap(int a){ 
				register Triangle * t = TriaAdjTriangles[a];
				t->TriaAdjSharedEdge[TriaAdjSharedEdge[a] & 3] &=55; // 23 + 32 
				TriaAdjSharedEdge[a] &=55 ;
			}
			void SetDet() {
				if(TriaVertices[0] && TriaVertices[1] && TriaVertices[2])    det = bamg::det(*TriaVertices[0],*TriaVertices[1],*TriaVertices[2]);
				else det = -1; }

			//Inline methods
			double qualite() ;
			void  Set(const Triangle &,const Triangles &,Triangles &);
			int   In(Vertex *v) const { return TriaVertices[0]==v || TriaVertices[1]==v || TriaVertices[2]==v ;}

	};

}
#endif
