/*!\file Vertex.c
 * \brief: implementation of the Vertex object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <string.h>
#include "./Vertex.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../include/macros.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION Vertex default constructor {{{1*/
Vertex::Vertex(){
	return;
}
/*}}}*/
/*FUNCTION Vertex constructor {{{1*/
Vertex::Vertex(int tria_id, double tria_x, double tria_y, double tria_z){

	/*all the initialization has been done by the initializer, just fill in the id: */
	this->id=tria_id;
	this->x=tria_x;
	this->y=tria_y;
	this->z=tria_z;

	return;
}
/*}}}*/
/*FUNCTION Vertex destructor {{{1*/
Vertex::~Vertex(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION copy {{{1*/
Object* Vertex::copy() {

	return new Vertex(*this); 

}
/*}}}*/
/*FUNCTION DeepEcho{{{1*/

void Vertex::DeepEcho(void){
	this->Echo();
}
/*}}}*/
/*FUNCTION Demarshall {{{1*/
void  Vertex::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&x,marshalled_dataset,sizeof(x));marshalled_dataset+=sizeof(x);
	memcpy(&y,marshalled_dataset,sizeof(y));marshalled_dataset+=sizeof(y);
	memcpy(&z,marshalled_dataset,sizeof(z));marshalled_dataset+=sizeof(z);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION Echo{{{1*/

void Vertex::Echo(void){

	printf("Vertex:\n");
	printf("   id: %i\n",id);
	printf("   x: %g\n",x);
	printf("   y: %g\n",y);
	printf("   z: %g\n",z);

	return;
}
/*}}}*/
/*FUNCTION Enum {{{1*/
int Vertex::Enum(void){

	return VertexEnum();

}
/*}}}*/
/*FUNCTION GetId{{{1*/
int    Vertex::GetId(void){ return id; }
/*}}}*/
/*FUNCTION GetName{{{1*/
char* Vertex::GetName(void){
	return "node";
}
/*}}}*/
/*FUNCTION Marshall {{{1*/
void  Vertex::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Vertex: */
	enum_type=VertexEnum();

	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);

	/*marshall Vertex data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&x,sizeof(x));marshalled_dataset+=sizeof(x);
	memcpy(marshalled_dataset,&y,sizeof(y));marshalled_dataset+=sizeof(y);
	memcpy(marshalled_dataset,&z,sizeof(z));marshalled_dataset+=sizeof(z);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION MarshallSize {{{1*/
int   Vertex::MarshallSize(){
	
	return sizeof(id)+
		sizeof(x)+
		sizeof(y)+
		sizeof(z)+
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION MyRank {{{1*/
int    Vertex::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION UpdateFromDakota {{{1*/
void  Vertex::UpdateFromDakota(void* vinputs){

	ISSMERROR("not supported yet!");
	
}
/*}}}*/
/*FUNCTION UpdateFromInputs {{{1*/
void  Vertex::UpdateFromInputs(void* vinputs){

	ISSMERROR("not supported yet!");
	
}
/*}}}*/
