/*! \file Vertex.h 
 *  \brief: header file for vertex object
 */

#ifndef _VERTEX_H_
#define _VERTEX_H_

#include "./Object.h"

class Vertex: public Object{

	private: 

		int  id;
		double x;
		double y;
		double z;

	public:

		/*FUNCTION constructors, destructors {{{1*/
		Vertex();
		Vertex(int id, double x, double y, double z);
		~Vertex();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		Object* copy();
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   GetId(void); 
		char* GetName();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank();
		void  UpdateFromDakota(void* vinputs);
		void  UpdateFromInputs(void* vinputs);
		/*}}}*/

};
#endif  /* _VERTEX_H */
