function plot_tensor_components(md,options_structure,width,i,tensor,type,plot_options);
%PLOT_TENSOR_COMPONENT - plot component of a tensor
%
%   Usage:
%      plot_tensor_components(md,options_structure,width,i,tensor,type,plot_option);
%
%   See also: PLOTMODEL, PLOT_UNIT, PLOT_MANAGER

%Compute the indexes of the components plots
upperplots=fix((i-1)/width);
if upperplots==0, leftplots=i-1; else leftplots=i-width*upperplots-1; end
if strcmpi(md.type,'2d')%3 components -> 3 indexes
	index1=4*width*upperplots+2*leftplots+1;
	index2=index1+1;
	index3=index1+width*2;
elseif strcmpi(md.type,'3d')%6 components -> 6 indexes
	index1=3*3*width*upperplots+3*leftplots+1;
	index2=index1+1;
	index3=index1+2;
	index4=index1+width*3;
	index5=index4+1;
	index6=index4+2;
end

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[tensor.xx isongrid]=processdata(md,tensor.xx,options_structure);
[tensor.yy isongrid]=processdata(md,tensor.yy,options_structure);
[tensor.xy isongrid]=processdata(md,tensor.xy,options_structure);
if  strcmpi(md.type,'3d')
	[tensor.xz isongrid]=processdata(md,tensor.xz,options_structure);
	[tensor.yz isongrid]=processdata(md,tensor.yz,options_structure);
	[tensor.zz isongrid]=processdata(md,tensor.zz,options_structure);
end

if (strcmpi(md.type,'2d')),
	subplot(2*width,2*width,index1),
	plot_unit(x,y,z,elements,tensor.xx,isongrid,is2d,options_structure)
	Apply_options_tensor(md,options_structure,type,'xx')
	subplot(2*width,2*width,index2),
	plot_unit(x,y,z,elements,tensor.yy,isongrid,is2d,options_structure)
	Apply_options_tensor(md,options_structure,type,'yy')
	subplot(2*width,2*width,index3),
	plot_unit(x,y,z,elements,tensor.xy,isongrid,is2d,options_structure)
	Apply_options_tensor(md,options_structure,type,'xy')
else
	subplot(3*width,3*width,index1),
	plot_unit(x,y,z,elements,tensor.xx,isongrid,is2d,options_structure)
	Apply_options_tensor(md,options_structure,type,'xx')
	subplot(3*width,3*width,index2),
	plot_unit(x,y,z,elements,tensor.yy,isongrid,is2d,options_structure)
	Apply_options_tensor(md,options_structure,type,'yy')
	subplot(3*width,3*width,index3),
	plot_unit(x,y,z,elements,tensor.zz,isongrid,is2d,options_structure)
	Apply_options_tensor(md,options_structure,type,'zz')
	subplot(3*width,3*width,index4),
	plot_unit(x,y,z,elements,tensor.xy,isongrid,is2d,options_structure)
	Apply_options_tensor(md,options_structure,type,'xy')
	subplot(3*width,3*width,index5),
	plot_unit(x,y,z,elements,tensor.xz,isongrid,is2d,options_structure)
	Apply_options_tensor(md,options_structure,type,'xz')
	subplot(3*width,3*width,index6),
	plot_unit(x,y,z,elements,tensor.yz,isongrid,is2d,options_structure)
	Apply_options_tensor(md,options_structure,type,'yz')
end
end

function Apply_options_tensor(md,options_structure,type,component)
	%apply options
	if isnan(options_structure.title)
		if ismember('_',type) %user plotet stress_tensor
			strings=strsplit(type,'_');
			string=strings{1};
		else %default plot: user requested stress
			string=type;
		end
		options_structure.title=[upper(string(1)) string(2:end) ' ' component];
	end 
	applyoptions(md,[],options_structure);
end
