function plot_manager(md,optionstring,width,i);
%PLOT__MANAGER - distribute the plots, called by plotmodel
%
%   Usage:
%      plot_manager(md,optionstring,width,i);
%
%   See also: PLOTMODEL, PLOT_UNIT

%parse options and get a structure of options. 
options_structure=parse_options(md,optionstring);

%get data to be displayed
data=findarg(optionstring,'data');data=data.value;

%figure out if this is a special plot
if ischar(data),

	switch data,

		case 'boundaries',
			plot_boundaries(md,options_structure,width,i);
			return;
		case 'elementnumbering',
			plot_elementnumbering(md,options_structure,width,i);
			return;
		case 'highlightelements',
			plot_highlightelements(md,options_structure,width,i);
			return;
		case 'segmentnumbering',
			plot_segmentnumbering(md,options_structure,width,i);
			return;
		case 'importancefactors',
			plot_importancefactors(md,options_structure,width,i);
			return;
		case 'elements_type',
			plot_elementstype(md,options_structure,width,i);
			return;
		case 'gridnumbering',
			plot_gridnumbering(md,options_structure,width,i);
			return;
		case 'highlightgrids',
			plot_highlightgrids(md,options_structure,width,i);
			return;
		case {'basal_drag','basal_dragx','basal_dragy'},
			plot_basaldrag(md,options_structure,width,i,data);
			return;
		case 'driving_stress',
			plot_drivingstress(md,options_structure,width,i);
			return;
		case 'mesh',
			plot_mesh(md,options_structure,width,i);
			return;
		case 'penalties',
			plot_penalties(md,options_structure,width,i);
			return;
		case 'quiver',
			plot_quiver(md,options_structure,width,i);
			return;
		case 'quiver3',
			plot_quiver3(md,options_structure,width,i);
			return;
		case 'quivervel',
			plot_quivervel(md,options_structure,width,i);
			return;
		case 'riftvel',
			plot_riftvel(md,options_structure,width,i);
			return;
		case 'riftrelvel',
			plot_riftrelvel(md,options_structure,width,i);
			return;
		case 'riftpenetration',
			plot_riftpenetration(md,options_structure,width,i);
			return;
		case 'sarpwr',
			plot_sarpwr(md,options_structure,width,i)
			return
		case {'segmentonneumann_diag','segmentonneumann_prog'}
			plot_segmentonneumann(md,options_structure,width,i,data)
			return
		case {'strainrate_tensor','strainrate','strainrate_principal','strainrate_principalaxis1','strainrate_principalaxis2','strainrate_principalaxis3',...
				'stress_tensor','stress','stress_principal','stress_principalaxis1','stress_principalaxis2','stress_principalaxis3',...
				'deviatoricstress_tensor','deviatoricstress','deviatoricstress_principal','deviatoricstress_principalaxis1','deviatoricstress_principalaxis2','deviatoricstress_principalaxis3'},
			plot_tensor(md,options_structure,width,i,data);
			return;
		case 'thermaltransient_results',
			plot_thermaltransient_results(md,options_structure,width,i);
			return;
		case 'transient_movie',
			plot_transient_movie(md,options_structure,width,i);
			return;
		case 'transient_results',
			plot_transient_results(md,options_structure,width,i);
			return;

	otherwise,

		if isfield(struct(md),data)
			data=eval(['md.' data ';']);
		else
			error('plot error message: data provided not supported yet. Type plotdoc for help');
		end
	end
end

%Figure out if this is a semi-transparent plot.
if ~isnan(options_structure.overlay),
	plot_overlay(md,data,options_structure,width,i);
	return;
end

%Figure out if this is a Section plot
if ~isnan(options_structure.sectionvalue)
	plot_section(md,data,options_structure,width,i);
	return;
end

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[data isongrid]=processdata(md,data,options_structure);

%standard plot:
subplot(width,width,i);
plot_unit(x,y,z,elements,data,isongrid,is2d,options_structure);

%apply all options
if isnan(options_structure.shading) & isnan(options_structure.edgecolor) & size(data,1)==md.numberofgrids,
	options_structure.shading='interp';
end
applyoptions(md,data,options_structure);
