function plot_quivervel(md,options_structure,width,i);
%PLOT_QUIVERVEL - superimpose arrows and magnitude of the velocity
%
%   Usage:
%      plot_quivervel(md,options_structure,width,i);
%
%   See also: PLOTMODEL, PLOT_UNIT, PLOT_MANAGER

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[vx isongrid]=processdata(md,md.vx,options_structure);
[vy isongrid]=processdata(md,md.vy,options_structure);
if ~isnan(md.vz)
	[vz isongrid]=processdata(md,md.vz,options_structure);
end

%density
if ~isnan(options_structure.density)
	x=x(1:options_structure.density:end);
	y=y(1:options_structure.density:end);
	z=z(1:options_structure.density:end);
	vx=vx(1:options_structure.density:end);
	vy=vy(1:options_structure.density:end);
	vz=vz(1:options_structure.density:end);
end

%plot
subplot(width,width,i); 
colormap('default')
plot_unit(x,y,z,elements,sqrt(vx.^2+vy.^2),isongrid,is2d,options_structure)

if is2d
	hold on
	colorbar;
	quiver(x,y,vx,vy,'k')
	alpha(0.7)
else
	hold on
	colorbar;
	quiver3(x,y,z,vx,vy,vz);
	alpha(0.7)
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Velocity';
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=1;
end
applyoptions(md,[],options_structure);
