/*!\file Vertex.c
 * \brief: implementation of the Vertex object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Vertex.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../include/macros.h"

/*Object constructors and destructor*/
/*FUNCTION Vertex default constructor {{{1*/
Vertex::Vertex(){
	return;
}
/*}}}*/
/*FUNCTION Vertex constructor {{{1*/
Vertex::Vertex(int tria_id, double tria_x, double tria_y, double tria_z){

	/*all the initialization has been done by the initializer, just fill in the id: */
	this->id=tria_id;
	this->x=tria_x;
	this->y=tria_y;
	this->z=tria_z;

	return;
}
/*}}}*/
/*FUNCTION Vertex destructor {{{1*/
Vertex::~Vertex(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION copy {{{1*/
Object* Vertex::copy() {

	return new Vertex(*this); 

}
/*}}}*/
/*FUNCTION DeepEcho{{{1*/

void Vertex::DeepEcho(void){

	printf("Vertex:\n");
	printf("   id: %i\n",id);
	hnodes.DeepEcho();
	hmatice.DeepEcho();
	hmatpar.DeepEcho();
	hnumpar.DeepEcho();
	properties.DeepEcho();

	return;
}
/*}}}*/
/*FUNCTION Demarshall {{{1*/
void  Vertex::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);

	/*demarshall hooks: */
	hnodes.Demarshall(&marshalled_dataset);
	hmatice.Demarshall(&marshalled_dataset);
	hmatpar.Demarshall(&marshalled_dataset);
	hnumpar.Demarshall(&marshalled_dataset);

	/*demarshall properties: */
	properties.Demarshall(&marshalled_dataset);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION Echo{{{1*/

void Vertex::Echo(void){

	printf("Vertex:\n");
	printf("   id: %i\n",id);
	hnodes.Echo();
	hmatice.Echo();
	hmatpar.Echo();
	hnumpar.Echo();
	properties.Echo();

	return;
}
/*}}}*/
/*FUNCTION Enum {{{1*/
int Vertex::Enum(void){

	return VertexEnum();

}
/*}}}*/
/*FUNCTION Marshall {{{1*/
void  Vertex::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Vertex: */
	enum_type=VertexEnum();

	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);

	/*marshall Vertex data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);

	/*Marshall hooks: */
	hnodes.Marshall(&marshalled_dataset);
	hmatice.Marshall(&marshalled_dataset);
	hmatpar.Marshall(&marshalled_dataset);
	hnumpar.Marshall(&marshalled_dataset);

	/*Marshall properties: */
	properties.Marshall(&marshalled_dataset);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION MarshallSize {{{1*/
int   Vertex::MarshallSize(){
	
	return sizeof(id)
		+hnodes.MarshallSize()
		+hmatice.MarshallSize()
		+hmatpar.MarshallSize()
		+hnumpar.MarshallSize()
		+properties.MarshallSize()
		+sizeof(int); //sizeof(int) for enum type
}
/*}}}*/
/*FUNCTION MyRank {{{1*/
int    Vertex::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION UpdateFromDakota {{{1*/
void  Vertex::UpdateFromDakota(void* vinputs){

	int     i;
	int     dofs[1]={0};
	double  temperature_list[3];
	double  temperature_average;
	double  B_list[3];
	double  B_average;
	double  new_h[3];

	/*dynamic objects pointed to by hooks: */
	Node**  nodes=NULL;
	Matpar* matpar=NULL;
	Matice* matice=NULL;
	Numpar* numpar=NULL;

	ParameterInputs* inputs=NULL;

	/*recover pointers: */
	inputs=(ParameterInputs*)vinputs;

	/*recover objects from hooks: */
	nodes=(Node**)hnodes.deliverp();
	matpar=(Matpar*)hmatpar.delivers();
	matice=(Matice*)hmatice.delivers();
	numpar=(Numpar*)hnumpar.delivers();

	/*Update internal data if inputs holds new values: */
	inputs->Recover("thickness",&this->properties.h[0],1,dofs,3,(void**)nodes);
		
	if(inputs->Recover("thickness",&new_h[0],1,dofs,3,(void**)nodes)){
	//density, needed later:
	double di=(this->matpar->GetRhoIce()/this->matpar->GetRhoWater());
	//Go through grids:
	for (i=0;i<3;i++){
	if(nodes[i]->IsOnShelf()){
	this->b[i]=this->b[i]-di*(new_h[i]-h[i]); //hydrostatic equilibrium;
	}
	this->s[i]=this->b[i]+new_h[i];
	this->h[i]=new_h[i];
	}
	}
	
}
/*}}}*/
/*FUNCTION UpdateFromInputs {{{1*/
void  Vertex::UpdateFromInputs(void* vinputs){

	int     i;
	int     dofs[1]={0};
	double  temperature_list[3];
	double  temperature_average;
	double  B_list[3];
	double  B_average;
	double  new_h[3];

	/*dynamic objects pointed to by hooks: */
	Node**  nodes=NULL;
	Matpar* matpar=NULL;
	Matice* matice=NULL;
	Numpar* numpar=NULL;

	ParameterInputs* inputs=NULL;

	/*recover pointers: */
	inputs=(ParameterInputs*)vinputs;

	/*recover objects from hooks: */
	nodes=(Node**)hnodes.deliverp();
	matpar=(Matpar*)hmatpar.delivers();
	matice=(Matice*)hmatice.delivers();
	numpar=(Numpar*)hnumpar.delivers();

	/*Update internal data if inputs holds new values: */
	//if (id==1) printf("WARNING if QMU: no hydrostatic equilibrium is applied here (conflict with prognostic, which does not have matpar)\n");
	//For now
	inputs->Recover("thickness",&this->properties.h[0],1,dofs,3,(void**)nodes);
	//Later
	/*
		if(inputs->Recover("thickness",&new_h[0],1,dofs,3,(void**)nodes)){
	//density, needed later:
	double di=(this->matpar->GetRhoIce()/this->matpar->GetRhoWater());
	//Go through grids:
	for (i=0;i<3;i++){
	if(nodes[i]->IsOnShelf()){
	this->b[i]=this->b[i]-di*(new_h[i]-h[i]); //hydrostatic equilibrium;
	}
	this->s[i]=this->b[i]+new_h[i];
	this->h[i]=new_h[i];
	}
	}
	*/
	inputs->Recover("surface",&this->properties.s[0],1,dofs,3,(void**)nodes);
	inputs->Recover("bed",&this->properties.b[0],1,dofs,3,(void**)nodes);
	inputs->Recover("drag",&this->properties.k[0],1,dofs,3,(void**)nodes);
	inputs->Recover("melting",&this->properties.melting[0],1,dofs,3,(void**)nodes);
	inputs->Recover("accumulation",&this->properties.accumulation[0],1,dofs,3,(void**)nodes);
	inputs->Recover("geothermalflux",&this->properties.geothermalflux[0],1,dofs,3,(void**)nodes);
	
	//Update material if necessary
	if(inputs->Recover("temperature_average",&temperature_list[0],1,dofs,3,(void**)nodes)){
		temperature_average=(temperature_list[0]+temperature_list[1]+temperature_list[2])/3.0;
		B_average=Paterson(temperature_average);
		matice->SetB(B_average);
	}
	
	if(inputs->Recover("B",&B_list[0],1,dofs,3,(void**)nodes)){
		B_average=(B_list[0]+B_list[1]+B_list[2])/3.0;
		matice->SetB(B_average);
	}

}
/*}}}*/
