/*
 * CreateElementsNodesAndMaterialsDiagnosticHoriz.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../include/typedefs.h"
#include "../IoModel.h"


void	CreateElementsNodesAndMaterialsDiagnosticHoriz(DataSet** pelements,DataSet** pnodes, DataSet** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle){


	/*output: int* epart, int* my_grids, double* my_bordergrids*/


	int i,j,k,n;
	extern int my_rank;
	extern int num_procs;

	/*DataSets: */
	DataSet*    elements  = NULL;
	DataSet*    nodes = NULL;
	DataSet*    materials = NULL;
	
	/*Objects: */
	Node*       node   = NULL;
	Tria*       tria = NULL;
	Penta*      penta = NULL;
	Matice*     matice  = NULL;
	Matpar*     matpar  = NULL;
	ElementProperties* tria_properties=NULL;
	ElementProperties* penta_properties=NULL;

	/*output: */
	int* epart=NULL; //element partitioning.
	int* npart=NULL; //node partitioning.
	int* my_grids=NULL;
	double* my_bordergrids=NULL;


	/*intermediary: */
	int elements_width; //size of elements
	double B_avg;
			
	/*tria constructor input: */
	int tria_id;
	int tria_matice_id;
	int tria_matpar_id;
	int tria_numpar_id;
	int tria_node_ids[3];
	double tria_h[3];
	double tria_s[3];
	double tria_b[3];
	double tria_k[3];
	double tria_melting[3];
	double tria_accumulation[3];
	int    tria_friction_type;
	double tria_p;
	double tria_q;
	int    tria_shelf;
	bool   tria_onwater; 
	
	/*matice constructor input: */
	int    matice_mid;
	double matice_B;
	double matice_n;
	
	/*penta constructor input: */
	int penta_id;
	int penta_matice_id;
	int penta_matpar_id;
	int penta_numpar_id;
	int penta_node_ids[6];
	double penta_h[6];
	double penta_s[6];
	double penta_b[6];
	double penta_k[6];
	int penta_friction_type;
	double penta_p;
	double penta_q;
	int penta_shelf;
	int penta_onbed;
	int penta_onsurface;
	int penta_collapse;
	double penta_melting[6];
	double penta_accumulation[6];
	bool   penta_onwater;

	/*matpar constructor input: */
	int	matpar_mid;
	double matpar_rho_ice; 
	double matpar_rho_water;
	double matpar_heatcapacity;
	double matpar_thermalconductivity;
	double matpar_latentheat;
	double matpar_beta;
	double matpar_meltingpoint;
	double matpar_mixed_layer_capacity;
	double matpar_thermal_exchange_velocity;
	double matpar_g;

	/* node constructor input: */
	int node_id;
	int node_partitionborder=0;
	double node_x[3];
	double node_sigma;
	int node_onbed;
	int node_onsurface;
	int node_onsheet;
	int node_onshelf;
	int node_upper_node_id;
	int node_numdofs;

		
	#ifdef _PARALLEL_
	/*Metis partitioning: */
	int  range;
	Vec  gridborder=NULL;
	int  my_numgrids;
	int* all_numgrids=NULL;
	int  gridcount;
	int  count;
	#endif
	int  first_grid_index;

	/*Rifts:*/
	int el1,el2;
	 
	/*First create the elements, nodes and material properties: */
	elements  = new DataSet(ElementsEnum());
	nodes     = new DataSet(NodesEnum());
	materials = new DataSet(MaterialsEnum());


	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn)goto cleanup_and_return;

	/*Width of elements: */
	if(strcmp(iomodel->meshtype,"2d")==0){
		elements_width=3; //tria elements
	}
	else{
		elements_width=6; //penta elements
	}



	#ifdef _PARALLEL_
	/*Determine parallel partitioning of elements: we use Metis for now. First load the data, then partition*/
	if(strcmp(iomodel->meshtype,"2d")==0){
		/*load elements: */
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	}
	else{
		/*load elements2d: */
		IoModelFetchData(&iomodel->elements2d,NULL,NULL,iomodel_handle,"elements2d");
	}

	MeshPartitionx(&epart, &npart,iomodel->numberofelements,iomodel->numberofnodes,iomodel->elements, iomodel->numberofelements2d,iomodel->numberofnodes2d,iomodel->elements2d,iomodel->numlayers,elements_width, iomodel->meshtype,num_procs);

	/*Free elements and elements2d: */
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->elements2d);


	/*Deal with rifts, they have to be included into one partition only, not several: */
	IoModelFetchData(&iomodel->riftinfo,&iomodel->numrifts,NULL,iomodel_handle,"riftinfo");

	for(i=0;i<iomodel->numrifts;i++){
		el1=(int)*(iomodel->riftinfo+RIFTINFOSIZE*i+2)-1; //matlab indexing to c indexing
		el2=(int)*(iomodel->riftinfo+RIFTINFOSIZE*i+3)-1; //matlab indexing to c indexing
		epart[el2]=epart[el1]; //ensures that this pair of elements will be in the same partition, as well as the corresponding grids;
	}
	/*Free rifts: */
	xfree((void**)&iomodel->riftinfo); 

	/*Used later on: */
	my_grids=(int*)xcalloc(iomodel->numberofnodes,sizeof(int));
	#endif



	/*elements created vary if we are dealing with a 2d mesh, or a 3d mesh: */

	/*2d mesh: */
	if (strcmp(iomodel->meshtype,"2d")==0){

		/*Fetch data needed: */
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
		IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
		IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
		IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
		IoModelFetchData(&iomodel->drag,NULL,NULL,iomodel_handle,"drag");
		IoModelFetchData(&iomodel->p,NULL,NULL,iomodel_handle,"p");
		IoModelFetchData(&iomodel->q,NULL,NULL,iomodel_handle,"q");
		IoModelFetchData(&iomodel->elementoniceshelf,NULL,NULL,iomodel_handle,"elementoniceshelf");
		IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,"elementonwater");
		IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
		IoModelFetchData(&iomodel->B,NULL,NULL,iomodel_handle,"B");
		IoModelFetchData(&iomodel->n,NULL,NULL,iomodel_handle,"n");
		IoModelFetchData(&iomodel->accumulation,NULL,NULL,iomodel_handle,"accumulation");
		IoModelFetchData(&iomodel->melting,NULL,NULL,iomodel_handle,"melting");
		
		for (i=0;i<iomodel->numberofelements;i++){

		#ifdef _PARALLEL_
		/*!All elements have been partitioned above, only create elements for this CPU: */
		if(my_rank==epart[i]){ 
		#endif
			
			if (*(iomodel->elements_type+2*i+0)==MacAyealFormulationEnum()){ //elements of type 1 are Hutter type Tria. Don't create this elements.
				
				/*ids: */
				tria_id=i+1; //matlab indexing.
				tria_matice_id=i+1; //refers to the corresponding material property card
				tria_matpar_id=iomodel->numberofelements+1;//refers to the corresponding parmat property card
				tria_numpar_id=1;

				/*vertices ids: */
				tria_node_ids[0]=(int)*(iomodel->elements+elements_width*i+0);
				tria_node_ids[1]=(int)*(iomodel->elements+elements_width*i+1);
				tria_node_ids[2]=(int)*(iomodel->elements+elements_width*i+2);

				/*thickness,surface and bed:*/
				tria_h[0]= *(iomodel->thickness+ ((int)*(iomodel->elements+elements_width*i+0)-1)); //remember, elements is an index of vertices offsets, in matlab indexing.
				tria_h[1]=*(iomodel->thickness+  ((int)*(iomodel->elements+elements_width*i+1)-1)); 
				tria_h[2]=*(iomodel->thickness+  ((int)*(iomodel->elements+elements_width*i+2)-1)) ;

				tria_s[0]=*(iomodel->surface+    ((int)*(iomodel->elements+elements_width*i+0)-1)); 
				tria_s[1]=*(iomodel->surface+    ((int)*(iomodel->elements+elements_width*i+1)-1)); 
				tria_s[2]=*(iomodel->surface+    ((int)*(iomodel->elements+elements_width*i+2)-1)); 

				tria_b[0]=*(iomodel->bed+        ((int)*(iomodel->elements+elements_width*i+0)-1)); 
				tria_b[1]=*(iomodel->bed+        ((int)*(iomodel->elements+elements_width*i+1)-1)); 
				tria_b[2]=*(iomodel->bed+        ((int)*(iomodel->elements+elements_width*i+2)-1)); 

				/*basal drag:*/
				tria_friction_type=(int)iomodel->drag_type;

				tria_k[0]=*(iomodel->drag+        ((int)*(iomodel->elements+elements_width*i+0)-1)); 
				tria_k[1]=*(iomodel->drag+        ((int)*(iomodel->elements+elements_width*i+1)-1)); 
				tria_k[2]=*(iomodel->drag+        ((int)*(iomodel->elements+elements_width*i+2)-1)); 
				
				tria_p=iomodel->p[i];
				tria_q=iomodel->q[i];

				/*meling and accumulation*/
				tria_melting[0]=*(iomodel->melting+        ((int)*(iomodel->elements+elements_width*i+0)-1));
				tria_melting[1]=*(iomodel->melting+        ((int)*(iomodel->elements+elements_width*i+1)-1));
				tria_melting[2]=*(iomodel->melting+        ((int)*(iomodel->elements+elements_width*i+2)-1));

				tria_accumulation[0]=*(iomodel->accumulation+        ((int)*(iomodel->elements+elements_width*i+0)-1));
				tria_accumulation[1]=*(iomodel->accumulation+        ((int)*(iomodel->elements+elements_width*i+1)-1));
				tria_accumulation[2]=*(iomodel->accumulation+        ((int)*(iomodel->elements+elements_width*i+2)-1));

				/*element on iceshelf, water?:*/
				tria_shelf=(int)*(iomodel->elementoniceshelf+i);
				tria_onwater=(bool)*(iomodel->elementonwater+i);

				/*Create properties: */
				tria_properties=new ElementProperties(3,tria_h, tria_s, tria_b, tria_k, tria_melting, tria_accumulation, NULL,
						tria_friction_type, tria_p, tria_q, tria_shelf, UNDEF,tria_onwater, UNDEF,UNDEF,UNDEF);

				/*Create tria element using its constructor:*/
				tria=new Tria(tria_id, tria_node_ids, tria_matice_id, tria_matpar_id, tria_numpar_id, tria_properties);

				/*delete properties: */
				delete tria_properties;

				/*Add tria element to elements dataset: */
				elements->AddObject(tria);

				/*Deal with material property card: */
				matice_mid=i+1; //same as the material id from the geom2 elements.
				
				/*Average B over 3 grid elements: */
				B_avg=0;
				for(j=0;j<3;j++){
					B_avg+=*(iomodel->B+((int)*(iomodel->elements+elements_width*i+j)-1));
				}
				B_avg=B_avg/3;
				matice_B=B_avg;
				matice_n=(double)*(iomodel->n+i);
				
				/*Create matice using its constructor:*/
				matice= new Matice(matice_mid,matice_B,matice_n);
		
				/*Add matice element to materials dataset: */
				materials->AddObject(matice);
		
			} //if(!MacAyealFormulationEnum)

			#ifdef _PARALLEL_
			/*Now that we are here, we can also start building the list of grids belonging to this node partition: we use 
			 *the  element index to do this. For each element n, we know index[n][0:2] holds the indices (matlab indexing) 
			 into the grid coordinates. If we start plugging 1 into my_grids for each index[n][i] (i=0:2), then my_grids 
			 will hold which grids belong to this partition*/
			my_grids[(int)*(iomodel->elements+elements_width*i+0)-1]=1;
			my_grids[(int)*(iomodel->elements+elements_width*i+1)-1]=1;
			my_grids[(int)*(iomodel->elements+elements_width*i+2)-1]=1;
			#endif

		#ifdef _PARALLEL_
		}//if(my_rank==epart[i])
		#endif

		}//for (i=0;i<numberofelements;i++)

	
		/*Free data : */
		xfree((void**)&iomodel->elements);
		xfree((void**)&iomodel->thickness);
		xfree((void**)&iomodel->surface);
		xfree((void**)&iomodel->bed);
		xfree((void**)&iomodel->drag);
		xfree((void**)&iomodel->p);
		xfree((void**)&iomodel->q);
		xfree((void**)&iomodel->elementoniceshelf);
		xfree((void**)&iomodel->elementonwater);
		xfree((void**)&iomodel->B);
		xfree((void**)&iomodel->n);
		xfree((void**)&iomodel->elements_type);

	}
	else{ //	if (strcmp(meshtype,"2d")==0)

		/*Fetch data needed: */
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
		IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
		IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
		IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
		IoModelFetchData(&iomodel->drag,NULL,NULL,iomodel_handle,"drag");
		IoModelFetchData(&iomodel->p,NULL,NULL,iomodel_handle,"p");
		IoModelFetchData(&iomodel->q,NULL,NULL,iomodel_handle,"q");
		IoModelFetchData(&iomodel->elementoniceshelf,NULL,NULL,iomodel_handle,"elementoniceshelf");
		IoModelFetchData(&iomodel->elementonbed,NULL,NULL,iomodel_handle,"elementonbed");
		IoModelFetchData(&iomodel->elementonsurface,NULL,NULL,iomodel_handle,"elementonsurface");
		IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
		IoModelFetchData(&iomodel->B,NULL,NULL,iomodel_handle,"B");
		IoModelFetchData(&iomodel->n,NULL,NULL,iomodel_handle,"n");
		IoModelFetchData(&iomodel->accumulation,NULL,NULL,iomodel_handle,"accumulation");
		IoModelFetchData(&iomodel->melting,NULL,NULL,iomodel_handle,"melting");
		IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,"elementonwater");
		
		for (i=0;i<iomodel->numberofelements;i++){
		#ifdef _PARALLEL_
		/*We are using our element partition to decide which elements will be created on this node: */
		if(my_rank==epart[i]){
		#endif

			if (*(iomodel->elements_type+2*i+0)==MacAyealFormulationEnum() | *(iomodel->elements_type+2*i+0)==PattynFormulationEnum()){ //elements of type 1 are Hutter type Tria. Don't create this elements.
			
				/*name and id: */
				penta_id=i+1; //matlab indexing.
				penta_matice_id=i+1; //refers to the corresponding material property card
				penta_matpar_id=iomodel->numberofelements+1;//refers to the corresponding parmat property card
				penta_numpar_id=1;

				/*vertices,thickness,surface,bed and drag: */
				for(j=0;j<6;j++){
					penta_node_ids[j]=(int)*(iomodel->elements+elements_width*i+j);
					penta_h[j]=*(iomodel->thickness+    ((int)*(iomodel->elements+elements_width*i+j)-1)); 
					penta_s[j]=*(iomodel->surface+    ((int)*(iomodel->elements+elements_width*i+j)-1)); 
					penta_b[j]=*(iomodel->bed+    ((int)*(iomodel->elements+elements_width*i+j)-1)); 
					penta_k[j]=*(iomodel->drag+        ((int)*(iomodel->elements+elements_width*i+j)-1)); 
					penta_melting[j]=*(iomodel->melting+        ((int)*(iomodel->elements+elements_width*i+j)-1));
					penta_accumulation[j]=*(iomodel->accumulation+        ((int)*(iomodel->elements+elements_width*i+j)-1));
				}

				/*basal drag:*/
				penta_friction_type=(int)iomodel->drag_type;
		
				penta_p=iomodel->p[i];
				penta_q=iomodel->q[i];

				/*diverse: */
				penta_shelf=(int)*(iomodel->elementoniceshelf+i);
				penta_onbed=(int)*(iomodel->elementonbed+i);
				penta_onsurface=(int)*(iomodel->elementonsurface+i);
				penta_onwater=(bool)*(iomodel->elementonwater+i);
				
				if (*(iomodel->elements_type+2*i+0)==MacAyealFormulationEnum()){ //elements of type 3 are MacAyeal type Penta. We collapse the formulation on their base.
					penta_collapse=1;
				}
				else{
					penta_collapse=0;
				}

				/*Create element properties: */
				penta_properties=new ElementProperties(6,penta_h, penta_s, penta_b, penta_k, penta_melting, penta_accumulation, NULL, penta_friction_type, penta_p, penta_q, penta_shelf, penta_onbed, penta_onwater, penta_onsurface, penta_collapse, UNDEF);

				/*Create Penta using its constructor:*/
				penta= new Penta(penta_id,penta_node_ids, penta_matice_id, penta_matpar_id, penta_numpar_id, penta_properties);

				/*delete properties: */
				delete penta_properties;

				/*Add penta element to elements dataset: */
				elements->AddObject(penta);
		

				/*Deal with material:*/
				matice_mid=i+1; //same as the material id from the geom2 elements.
				/*Average B over 6 element grids: */
				B_avg=0;
				for(j=0;j<6;j++){
					B_avg+=*(iomodel->B+((int)*(iomodel->elements+elements_width*i+j)-1));
				}
				B_avg=B_avg/6;
				matice_B= B_avg;
				matice_n=(double)*(iomodel->n+i);
		
				/*Create matice using its constructor:*/
				matice= new Matice(matice_mid,matice_B,matice_n);
		
				/*Add matice element to materials dataset: */
				materials->AddObject(matice);
				
			}

			#ifdef _PARALLEL_
			/*Now that we are here, we can also start building the list of grids belonging to this node partition: we use 
			 *the  element index to do this. For each element n, we know index[n][0:2] holds the indices (matlab indexing) 
			 into the grid coordinates. If we start plugging 1 into my_grids for each index[n][i] (i=0:2), then my_grids 
			 will hold which grids belong to this partition*/
			my_grids[(int)*(iomodel->elements+elements_width*i+0)-1]=1;
			my_grids[(int)*(iomodel->elements+elements_width*i+1)-1]=1;
			my_grids[(int)*(iomodel->elements+elements_width*i+2)-1]=1;
			my_grids[(int)*(iomodel->elements+elements_width*i+3)-1]=1;
			my_grids[(int)*(iomodel->elements+elements_width*i+4)-1]=1;
			my_grids[(int)*(iomodel->elements+elements_width*i+5)-1]=1;
			#endif

		#ifdef _PARALLEL_
		}//if(my_rank==epart[i])
		#endif

		}//for (i=0;i<numberofelements;i++)

		/*Free data: */
		xfree((void**)&iomodel->elements);
		xfree((void**)&iomodel->thickness);
		xfree((void**)&iomodel->surface);
		xfree((void**)&iomodel->bed);
		xfree((void**)&iomodel->drag);
		xfree((void**)&iomodel->p);
		xfree((void**)&iomodel->q);
		xfree((void**)&iomodel->elementoniceshelf);
		xfree((void**)&iomodel->elementonbed);
		xfree((void**)&iomodel->elementonsurface);
		xfree((void**)&iomodel->elements_type);
		xfree((void**)&iomodel->n);
		xfree((void**)&iomodel->B);
		xfree((void**)&iomodel->accumulation);
		xfree((void**)&iomodel->melting);
		xfree((void**)&iomodel->elementonwater);

	} //if (strcmp(meshtype,"2d")==0)

	/*Add one constant material property to materials: */
	matpar_mid=iomodel->numberofelements+1; //put it at the end of the materials
	matpar_g=iomodel->g; 
	matpar_rho_ice=iomodel->rho_ice; 
	matpar_rho_water=iomodel->rho_water; 
	matpar_thermalconductivity=iomodel->thermalconductivity; 
	matpar_heatcapacity=iomodel->heatcapacity; 
	matpar_latentheat=iomodel->latentheat; 
	matpar_beta=iomodel->beta; 
	matpar_meltingpoint=iomodel->meltingpoint; 
	matpar_mixed_layer_capacity=iomodel->mixed_layer_capacity; 
	matpar_thermal_exchange_velocity=iomodel->thermal_exchange_velocity; 

	/*Create matpar object using its constructor: */
	matpar=new Matpar(matpar_mid,matpar_rho_ice,matpar_rho_water,matpar_heatcapacity,matpar_thermalconductivity,
			matpar_latentheat,matpar_beta,matpar_meltingpoint,matpar_mixed_layer_capacity,
			matpar_thermal_exchange_velocity,matpar_g);
		
	/*Add to materials datset: */
	materials->AddObject(matpar);
	
	#ifdef _PARALLEL_
		/*From the element partitioning, we can determine which grids are on the inside of this cpu's 
		 *element partition, and which are on its border with other nodes:*/
		gridborder=NewVec(iomodel->numberofnodes);

		for (i=0;i<iomodel->numberofnodes;i++){
			if(my_grids[i])VecSetValue(gridborder,i,1,ADD_VALUES);
		}
		VecAssemblyBegin(gridborder);
		VecAssemblyEnd(gridborder);

		#ifdef _ISSM_DEBUG_
		VecView(gridborder,PETSC_VIEWER_STDOUT_WORLD);
		#endif
		
		VecToMPISerial(&my_bordergrids,gridborder);

		#ifdef _ISSM_DEBUG_
		if(my_rank==0){
			for (i=0;i<iomodel->numberofnodes;i++){
				printf("Grid id %i Border grid %lf\n",i+1,my_bordergrids[i]);
			}
		}
		#endif
	#endif

	/*Partition penalties in 3d: */
	if(strcmp(iomodel->meshtype,"3d")==0){
	
		/*Get penalties: */
		IoModelFetchData(&iomodel->penalties,&iomodel->numpenalties,NULL,iomodel_handle,"penalties");

		if(iomodel->numpenalties){

			iomodel->penaltypartitioning=(int*)xmalloc(iomodel->numpenalties*sizeof(int));
			#ifdef _SERIAL_
			for(i=0;i<iomodel->numpenalties;i++)iomodel->penaltypartitioning[i]=1;
			#else
			for(i=0;i<iomodel->numpenalties;i++)iomodel->penaltypartitioning[i]=-1;

			for(i=0;i<iomodel->numpenalties;i++){
				first_grid_index=(int)(*(iomodel->penalties+i*iomodel->numlayers+0)-1);
				if((my_grids[first_grid_index]==1) && (my_bordergrids[first_grid_index]<=1.0) ) { //this grid belongs to this node's internal partition  grids
					/*All grids that are being penalised belong to this node's internal grid partition.:*/
					iomodel->penaltypartitioning[i]=1;
				}
				if(my_bordergrids[first_grid_index]>1.0) { //this grid belongs to a partition border
					iomodel->penaltypartitioning[i]=0;
				}
			}
			#endif
		}

		/*Free penalties: */
		xfree((void**)&iomodel->penalties);
	}

	/*Ok, let's summarise. Now, every CPU has the following two arrays: my_grids, and my_bordergrids. 
	 We can therefore determine  which grids are internal to this node's partition 
	 and which ones are shared with other nodes because they are on the border of this node's partition. Knowing 
	 that, go and create the grids*/

	/*Create nodes from x,y,z, as well as the spc values on those grids: */
		
	/*First fetch data: */
	if (strcmp(iomodel->meshtype,"3d")==0){
		IoModelFetchData(&iomodel->deadgrids,NULL,NULL,iomodel_handle,"deadgrids");
		IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	}
	IoModelFetchData(&iomodel->x,NULL,NULL,iomodel_handle,"x");
	IoModelFetchData(&iomodel->y,NULL,NULL,iomodel_handle,"y");
	IoModelFetchData(&iomodel->z,NULL,NULL,iomodel_handle,"z");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");

	/*Get number of dofs per node: */
	DistributeNumDofs(&node_numdofs,iomodel->analysis_type,iomodel->sub_analysis_type);

	for (i=0;i<iomodel->numberofnodes;i++){
	#ifdef _PARALLEL_

	/*keep only this partition's nodes:*/
	if((my_grids[i]==1)){
	#endif

		node_id=i+1; //matlab indexing
			
		
		#ifdef _PARALLEL_
		if(my_bordergrids[i]>1.0) { //this grid belongs to a partition border
			node_partitionborder=1;
		}
		else{
			node_partitionborder=0;
		}
		#else
			node_partitionborder=0;
		#endif

		node_x[0]=iomodel->x[i];
		node_x[1]=iomodel->y[i];
		node_x[2]=iomodel->z[i];
		node_sigma=(iomodel->z[i]-iomodel->bed[i])/(iomodel->thickness[i]);
		
		node_onbed=(int)iomodel->gridonbed[i];
		node_onsurface=(int)iomodel->gridonsurface[i];	
		node_onshelf=(int)iomodel->gridoniceshelf[i];	
		node_onsheet=(int)iomodel->gridonicesheet[i];	

		if (strcmp(iomodel->meshtype,"3d")==0){
			if (isnan(iomodel->uppernodes[i])){
				node_upper_node_id=node_id;  //nodes on surface do not have upper nodes, only themselves.
			}
			else{
				node_upper_node_id=(int)iomodel->uppernodes[i];
			}
		}
		else{
			/*If we are running 2d, upper_node does not mean much. Just point towards itself!:*/
			node_upper_node_id=node_id;
		}

		/*Create node using its constructor: */
		node=new Node(node_id,node_partitionborder,node_numdofs,node_x,node_sigma,node_onbed,node_onsurface,node_upper_node_id,node_onshelf,node_onsheet);

		/*set single point constraints.: */
		if (strcmp(iomodel->meshtype,"3d")==0){
			/*On a 3d mesh, we may have collapsed elements, hence dead grids. Freeze them out: */
			if (iomodel->deadgrids[i]){
				for(k=1;k<=node_numdofs;k++){
					node->FreezeDof(k);
				}
			}
		}
		if (iomodel->gridonhutter[i]){
			for(k=1;k<=node_numdofs;k++){
				node->FreezeDof(k);
			}
		}
		/*Add node to nodes dataset: */
		nodes->AddObject(node);

	#ifdef _PARALLEL_
	} //if((my_grids[i]==1))
	#endif
	}

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	elements->Presort();
	nodes->Presort();
	materials->Presort();

	/*Clean fetched data: */
	xfree((void**)&iomodel->deadgrids);
	xfree((void**)&iomodel->x);
	xfree((void**)&iomodel->y);
	xfree((void**)&iomodel->z);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridoniceshelf);
	

	/*Keep partitioning information into iomodel*/
	iomodel->epart=epart;
	iomodel->my_grids=my_grids;
	iomodel->my_bordergrids=my_bordergrids;

	/*Free ressources:*/
	#ifdef _PARALLEL_
	xfree((void**)&all_numgrids);
	xfree((void**)&npart);
	VecFree(&gridborder);
	#endif

	cleanup_and_return:

	/*Assign output pointer: */
	*pelements=elements;
	*pnodes=nodes;
	*pmaterials=materials;

}
