/*!\file Node.h
 * \brief: header file for node object
 */

#ifndef _NODE_H_
#define _NODE_H_

#include "./Object.h"
#include "../toolkits/toolkits.h"

#define MAXDOFSPERNODE 4
#define PSSTRINGLENGTH 20

class Node: public Object{

	private: 
		/*raw data coming from the model processor: */
		int	    id; /*! id, to track it*/
		int     partitionborder; /*! during parallel partitioning, does this grid belong to a partition border?*/
		int     numberofdofs; //real number of dofs, between 0 and MAXDOFSPERNODE
		int     clone;  /*!this nodes is one the partition border, and is cloned*/
		double	x[3]; /*! coordinates*/
		double	sigma; /*! sigma = (z-bed)/thickness*/
		int	    onbed; /*! for 3d, on bedrock*/
		int	    onsurface; /*! for 3d, on surface*/
		int	    onshelf; 
		int	    onsheet;

		/*for dof constraining: */
		int     mset[MAXDOFSPERNODE];
		int     nset[MAXDOFSPERNODE];
		int     fset[MAXDOFSPERNODE];
		int     sset[MAXDOFSPERNODE];

		int   upper_node_id;
		Node* upper_node;
		int   upper_node_offset;

		/*data that is post processed : */
		int doflist[MAXDOFSPERNODE]; //dof list on which we solve
		int doflist1[1]; //1d dof list to recover input parameters

	public:

		Node();
		Node(int node_id,int node_partitionborder,int node_numdofs, double node_x[3],double sigma,int node_onbed,int node_onsurface,int upper_node_id,int onshelf,int onsheet);
		~Node();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(void); 
		int   MyRank(void);
		void  DistributeDofs(int* pdofcount,int* pdofcount1);
		void  UpdateDofs(int dofcount,int dofcount1);
		void  ShowBorderDofs(int* borderdofs,int* borderdofs1);
		void  UpdateBorderDofs(int* allborderdofs,int* allborderdofs1);
		void  CreatePartition(Vec partition);
		void  SetClone(int* minranks);
		int   GetNumberOfDofs();
		int   IsClone();
		void  ApplyConstraint(Vec yg,int dof,double value);
		void  DofInSSet(int dof);
		void  DofInMSet(int dof);
		 int  DofIsInMSet(int dof);
		int   GetDof(int dofindex);
		void  CreateVecSets(Vec pv_g,Vec pv_m,Vec pv_n,Vec pv_f,Vec pv_s);
		void  GetDofList(int* outdoflist,int* pnumberofdofspernode);
		int   GetDofList1(void);
		double GetX();
		double GetY();
		double GetZ();
		double GetSigma();
		Object* copy();
		void  UpdateFromInputs(void* inputs);
		void  Configure(void* pnodes);
		Node* GetUpperNode();
		int   IsOnBed();
		int   IsOnSurface();
		void  FreezeDof(int dof);
		void  FieldAverageOntoVertices(Vec field,double* field_serial,char* fieldname);
		void  FieldDepthAverageAtBase(Vec field,double* field_serial,char* fieldname);
		int   IsOnShelf();
		int   IsOnSheet();
		void  FieldExtrude(Vec field,double* field_serial,char* field_name);
		void  UpdateNodePosition(double* thickness,double* bed);
};

#endif  /* _NODE_H_ */

