function results=prognostic2_core(models,inputs,analysis_type,sub_analysis_type)
%PROGNOSTIC2_CORE - linear solution sequence
%
%   Usage:
%      h_g=prognostic2_core(m,inputs,analysis_type,sub_analysis_type)

	%get FE model
	m=models.p;
	results.time=0;
	results.step=1;

	displaystring(m.parameters.verbose,'\n%s',['depth averaging velocity...']);
	%Take only the first two dofs of m.parameters.u_g
	vx_g=get(inputs,'vx',1);
	vy_g=get(inputs,'vy',1);
	vx_g=FieldDepthAverage(m.elements,m.nodes,m.loads,m.materials,m.parameters,vx_g,'vx');
	vy_g=FieldDepthAverage(m.elements,m.nodes,m.loads,m.materials,m.parameters,vy_g,'vy');
	inputs=add(inputs,'vx_average',vx_g,'doublevec',1,m.parameters.numberofnodes);
	inputs=add(inputs,'vy_average',vy_g,'doublevec',1,m.parameters.numberofnodes);

	displaystring(m.parameters.verbose,'\n%s',['call computational core:']);
	results.h_g=diagnostic_core_linear(m,inputs,analysis_type,sub_analysis_type);

	displaystring(m.parameters.verbose,'\n%s',['extrude computed thickness on all layers:']);
%	results.h_g=FieldExtrude(m.elements,m.nodes,m.loads,m.materials,m.parameters,results.h_g,'thickness',0);

end %end function
