/*! \file CreateLoadsPrognostic2.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../include/typedefs.h"
#include "../IoModel.h"

void	CreateLoadsPrognostic2(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i,j;
	int i1,i2;
	int pos1,pos2;
	double e1,e2;

	extern int my_rank;
	extern int num_procs;

	DataSet*       loads        = NULL;
	Numericalflux* numericalflux= NULL;

	/*numericalflux intermediary data: */
	char numericalflux_type[NUMERICALFLUXSTRING];
	int  numericalflux_id;
	int  numericalflux_node_ids[MAX_NUMERICALFLUX_NODES];
	int  numericalflux_elem_ids[MAX_NUMERICALFLUX_ELEMS];

	/*Create loads: */
	loads   = new DataSet(LoadsEnum());

	/*Get edges and elements*/
	IoModelFetchData(&iomodel->edges,&iomodel->numberofedges,NULL,iomodel_handle,"edges");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");

	/*First load data:*/
	for (i=0;i<iomodel->numberofedges;i++){

		/*Get left and right elements*/
		e1=iomodel->edges[4*i+2]-1; //edges are [node1 node2 elem1 elem2]
		e2=iomodel->edges[4*i+3]-1; //edges are [node1 node2 elem1 elem2]

		#ifdef _PARALLEL_
		if (iomodel->epart[(int)e1]!=my_rank){
			/*This load does not belong to this cluster node, as it references an element 
			 *that does not belong to this node's partition. Drop this 'i':*/
			continue;
		}
		#endif

		/*Create load*/
		numericalflux_id=i+1; //Matlab indexing

		if (!isnan(e2)){
			strcpy(numericalflux_type,"internal");

			numericalflux_elem_ids[0]=(int)e1+1;//id is in matlab index
			numericalflux_elem_ids[1]=(int)e2+1;//id is in matlab index

			/*Now, we must get the nodes of the 4 nodes located on the edge*/

			/*1: Get vertices ids*/
			i1=(int)iomodel->edges[4*i+0];
			i2=(int)iomodel->edges[4*i+1];

			/*2: Get the column where these ids are located in the index*/
			pos1=pos2=UNDEF;
			for(j=0;j<3;j++){
				if (iomodel->elements[3*(int)e1+j]==i1) pos1=j;
				if (iomodel->elements[3*(int)e2+j]==i1) pos2=j;
			}
			ISSMASSERT(pos1!=UNDEF && pos2!=UNDEF);

			/*3: We have the id of the elements and the position of the vertices in the index
			 * we can compute their dofs!*/
			numericalflux_node_ids[0]=3*(int)e1+pos1+1;      //id is in matlab index
			numericalflux_node_ids[1]=3*(int)e1+(pos1+1)%3+1;
			numericalflux_node_ids[2]=3*(int)e2+pos2+1;
			numericalflux_node_ids[3]=3*(int)e2+(pos2-1)%3+1;
		}
		else{
			strcpy(numericalflux_type,"boundary");

			numericalflux_elem_ids[0]=(int)e1+1;

			/*1: Get vertices ids*/
			i1=(int)iomodel->edges[4*i+0];
			i2=(int)iomodel->edges[4*i+1];

			/*2: Get the column where these ids are located in the index*/
			pos1==UNDEF;
			for(j=0;j<3;j++){
				if (iomodel->elements[3*(int)e1+j]==i1) pos1=j;
			}
			ISSMASSERT(pos1!=UNDEF);

			/*3: We have the id of the elements and the position of the vertices in the index
			 * we can compute their dofs!*/
			numericalflux_node_ids[0]=3*(int)e1+pos1+1; //id is in matlab index
			numericalflux_node_ids[1]=3*(int)e1+(pos1+1)%3+1;
		}

		numericalflux = new Numericalflux(numericalflux_id,numericalflux_type,numericalflux_node_ids,numericalflux_elem_ids);

		loads->AddObject(numericalflux);

	}

	/*Free data: */
	xfree((void**)&iomodel->edges);
	xfree((void**)&iomodel->elements);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	/*Assign output pointer: */
	*ploads=loads;

}
