function md=prognostic2(md)
%PROGNOSITC2 - prognostic2 solution sequence.
%
%   Usage:
%      md=prognostic2(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	models.analysis_type=Prognostic2AnalysisEnum; %needed for processresults
	
	displaystring(md.verbose,'%s',['reading prognostic2 model data']);
	md.analysis_type=Prognostic2AnalysisEnum; models.p=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%initialize inputs
	displaystring(md.verbose,'\n%s',['setup inputs...']);
	inputs=inputlist;
	inputs=add(inputs,'vx',models.p.parameters.vx_g,'doublevec',1,models.p.parameters.numberofnodes);
	inputs=add(inputs,'vy',models.p.parameters.vy_g,'doublevec',1,models.p.parameters.numberofnodes);
	inputs=add(inputs,'thickness',models.p.parameters.h_g,'doublevec',1,models.p.parameters.numberofnodes);
	inputs=add(inputs,'melting',models.p.parameters.m_g,'doublevec',1,models.p.parameters.numberofnodes);
	inputs=add(inputs,'accumulation',models.p.parameters.a_g,'doublevec',1,models.p.parameters.numberofnodes);
	inputs=add(inputs,'dt',models.p.parameters.dt*models.p.parameters.yts,'double');

	displaystring(md.verbose,'\n%s',['call computational core:']);
	results=prognostic2_core(models,inputs,Prognostic2AnalysisEnum(),NoneAnalysisEnum());

	displaystring(md.verbose,'\n%s',['load results...']);
	if ~isstruct(md.results), md.results=struct(); end
	md.results.prognostic2=processresults(models, results);

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
