/*!\file Numericalflux.h
 * \brief: header file for icefront object
 */

#ifndef _NUMERICALFLUX_H_
#define _NUMERICALFLUX_H_

#include "./Load.h"
#include "./Matpar.h"
#include "./Element.h"
#include "./Node.h"

#define NUMERICALFLUXSTRING 20    //max string length
#define MAX_NUMERICALFLUX_NODES 4 //max number of grids for a certain load
#define MAX_NUMERICALFLUX_ELEMS 2 //max number of elements for a certain load

class Element;
class Numericalflux: public Load {

	private: 
		/*Type of numerical flux*/
		int  id;
		char type[NUMERICALFLUXSTRING];
	
		/*elements: */
		Element* elements[MAX_NUMERICALFLUX_ELEMS];
		int      element_ids[MAX_NUMERICALFLUX_ELEMS];
		int      element_offsets[MAX_NUMERICALFLUX_ELEMS];

		/*nodes: */
		Node* nodes[MAX_NUMERICALFLUX_NODES];
		int   node_ids[MAX_NUMERICALFLUX_NODES];
		int   node_offsets[MAX_NUMERICALFLUX_NODES];

	public:

		Numericalflux();
		Numericalflux(int numericalflux_id,char numericalflux_type[NUMERICALFLUXSTRING], int numericalflux_node_ids[MAX_NUMERICALFLUX_NODES],int numericalflux_element_ids[MAX_NUMERICALFLUX_ELEMS]);
		Object* copy();
		~Numericalflux();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		void  GetJacobianDeterminant(double* pJdet,double xyz_list[4][3], double gauss_coord);
		void  GetNodalFunctions(double* l1l4, double gauss_coord);
		int   MyRank();
		void  DistributeNumDofs(int* numdofspernode,int analysis_type,int sub_analysis_type);
		void  Configure(void* elements,void* nodes,void* materials);
		void  GetDofList(int* doflist,int* pnumberofdofs);
		void  UpdateFromInputs(void* inputs);
		
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrix(Mat Kgg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrixInternal(Mat Kgg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrixBoundary(Mat Kgg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVectorInternal(Vec pg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVectorBoundary(Vec pg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
};

#endif  /* _NUMERICALFLUX_H_ */
