/*!\file: CreateParametersPrognostic2.cpp
 * \brief driver for creating parameters dataset, for prognostic analysis.
 */ 


#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../IoModel.h"

void CreateParametersPrognostic2(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int      i,j;
	int      dim;
	double*  elements;
	int*     part;

	double* vx=NULL;
	double* vx_g=NULL;
	double* vy=NULL;
	double* vy_g=NULL;
	double* thickness=NULL;
	double* h_g=NULL;
	double* accumulation=NULL;
	double* a_g=NULL;
	double* melting=NULL;
	double* m_g=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Create transformatiob vector for DG inputs*/
	IoModelFetchData(&elements,NULL,NULL,iomodel_handle,"elements");
	part=(int*)xcalloc(iomodel->numberofelements*3,sizeof(int));
	for(i=0;i<iomodel->numberofelements;i++){
		for(j=0;j<3;j++){
			part[3*i+j]=(int)elements[3*i+j]-1; //Matlab to C indexing
			ISSMASSERT(part[3*i+j]<iomodel->numberofnodes);
		}
	}
	xfree((void**)&elements);

	/*Get vx: */
	IoModelFetchData(&vx,NULL,NULL,iomodel_handle,"vx");
	vx_g=(double*)xcalloc(iomodel->numberofelements*3,sizeof(double));
	if(vx) for(i=0;i<3*iomodel->numberofelements;i++) vx_g[i]=vx[part[i]]/iomodel->yts;

	count++;
	param= new Param(count,"vx_g",DOUBLEVEC);
	param->SetDoubleVec(vx_g,3*iomodel->numberofelements,1);
	parameters->AddObject(param);
	xfree((void**)&vx);

	/*Get vy: */
	IoModelFetchData(&vy,NULL,NULL,iomodel_handle,"vy");
	vy_g=(double*)xcalloc(iomodel->numberofelements*3,sizeof(double));
	if(vy) for(i=0;i<3*iomodel->numberofelements;i++) vy_g[i]=vy[part[i]]/iomodel->yts;

	count++;
	param= new Param(count,"vy_g",DOUBLEVEC);
	param->SetDoubleVec(vy_g,3*iomodel->numberofelements,1);
	parameters->AddObject(param);
	xfree((void**)&vy);

	/*Get thickness: */
	IoModelFetchData(&thickness,NULL,NULL,iomodel_handle,"thickness");
	h_g=(double*)xcalloc(iomodel->numberofelements*3,sizeof(double));
	if(thickness) for(i=0;i<3*iomodel->numberofelements;i++) h_g[i]=thickness[part[i]]/iomodel->yts;

	count++;
	param= new Param(count,"h_g",DOUBLEVEC);
	param->SetDoubleVec(h_g,3*iomodel->numberofelements,1);
	parameters->AddObject(param);
	xfree((void**)&thickness);

	/*Get accumulation: */
	IoModelFetchData(&accumulation,NULL,NULL,iomodel_handle,"accumulation");
	a_g=(double*)xcalloc(iomodel->numberofelements*3,sizeof(double));
	if(accumulation) for(i=0;i<3*iomodel->numberofelements;i++) a_g[i]=accumulation[part[i]]/iomodel->yts;

	count++;
	param= new Param(count,"a_g",DOUBLEVEC);
	param->SetDoubleVec(a_g,3*iomodel->numberofelements,1);
	parameters->AddObject(param);
	xfree((void**)&accumulation);

	/*Get melting: */
	IoModelFetchData(&melting,NULL,NULL,iomodel_handle,"melting");
	m_g=(double*)xcalloc(iomodel->numberofelements*3,sizeof(double));
	if(melting) for(i=0;i<3*iomodel->numberofelements;i++) m_g[i]=melting[part[i]]/iomodel->yts;

	count++;
	param= new Param(count,"m_g",DOUBLEVEC);
	param->SetDoubleVec(m_g,3*iomodel->numberofelements,1);
	parameters->AddObject(param);
	xfree((void**)&melting);

	/*Free partitioning vector*/
	xfree((void**)&part);

	/*Assign output pointer: */
	*pparameters=parameters;
}
