function outoptions=process_solve_options(options)
%DEFAULT_SOLVE_OPTIONS - set up default options for solve phase
%
%   Usage:
%      options=process_solve_options(options)
%
%   See also: SOLVE

%analysis_type: check on this option, error out otherwise
analysis_type=getfieldvalueerr(options,'analysis_type');

%sub_analysis_type: check on it, not mandatory
sub_analysis_type=getfieldvalue(options,'sub_analysis_type','none');

%batch mode for launching jobs.
outoptions.batch=getfieldvalue(options,'batch','no');

%directory 
outoptions.directory=getfieldvalue(options,'directory','');

%check solution type is supported
if ~ismemberi(analysis_type,{'diagnostic','prognostic','prognostic2','thermal','steadystate','parameters','transient',...
		'balancedthickness','balancedvelocities','slopecompute'}),
	error(['process_solve_options error message: analysis_type ' analysis_type ' not supported yet!']);
else
	%convert to enum
	outoptions.analysis_type=eval([upper(analysis_type(1)) lower(analysis_type(2:end)) 'AnalysisEnum()']);
end
if ~ismemberi(sub_analysis_type,{'steady','transient','none','horiz','adjoint','gradient','inverse','vert',''}),
	error(['process_solve_options error message: sub_analysis_type ' sub_analysis_type ' not supported yet!']);
else
	%convert to enum
	outoptions.sub_analysis_type=eval([upper(sub_analysis_type(1)) lower(sub_analysis_type(2:end)) 'AnalysisEnum()']);
end

%  process qmu arguments
outoptions.qmudir=getfieldvalue(options,'qmudir','qmu');  % qmudir =['qmu_' datestr(now,'yyyymmdd_HHMMSS')];
outoptions.qmufile=getfieldvalue(options,'qmufile','qmu');% qmufile cannot be changed unless ????script.sh is also changed
outoptions.ivar=getfieldvalue(options,'ivar',1);
outoptions.iresp=getfieldvalue(options,'iresp',1);
outoptions.imethod=getfieldvalue(options,'imethod',1);
outoptions.iparams=getfieldvalue(options,'iparams',1);
outoptions.runmpi=getfieldvalue(options,'runmpi',false);
