/*!\file: CreateParametersPrognostic2.cpp
 * \brief driver for creating parameters dataset, for prognostic analysis.
 */ 


#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"

void CreateParametersPrognostic2(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	Param*   param = NULL;
	DataSet* parameters=NULL;
	int      count;
	int      i;
	int      dim;

	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	double* u_g=NULL;
	double* pressure=NULL;
	double* temperature=NULL;
	double* thickness=NULL;
	double* surface=NULL;
	double* bed=NULL;
	double* accumulation=NULL;
	double* melting=NULL;

	/*recover parameters : */
	parameters=*pparameters;

	count=parameters->Size();

	/*Get vx and vy: */
	IoModelFetchData(&vx,NULL,NULL,iomodel_handle,"vx");
	IoModelFetchData(&vy,NULL,NULL,iomodel_handle,"vy");
	IoModelFetchData(&vz,NULL,NULL,iomodel_handle,"vz");

	u_g=(double*)xcalloc(iomodel->numberofnodes*3,sizeof(double));

	if(vx) for(i=0;i<iomodel->numberofnodes;i++)u_g[3*i+0]=vx[i]/iomodel->yts;
	if(vy) for(i=0;i<iomodel->numberofnodes;i++)u_g[3*i+1]=vy[i]/iomodel->yts;
	if(vz) for(i=0;i<iomodel->numberofnodes;i++)u_g[3*i+2]=vz[i]/iomodel->yts;

	count++;
	param= new Param(count,"u_g",DOUBLEVEC);
	param->SetDoubleVec(u_g,3*iomodel->numberofnodes,3);
	parameters->AddObject(param);


	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	xfree((void**)&u_g);

	/*Get pressure if 3d iomodel: */
	parameters->FindParam(&dim,"dim");
	if (dim==3){ 
		IoModelFetchData(&pressure,NULL,NULL,iomodel_handle,"pressure");
		
		count++;
		param= new Param(count,"p_g",DOUBLEVEC);
		if(pressure) param->SetDoubleVec(pressure,iomodel->numberofnodes,1);
		else param->SetDoubleVec(pressure,0,0);
		parameters->AddObject(param);

		/*Free pressure: */
		xfree((void**)&pressure);
	}

	/*Get temperature if 3d iomodel: */
	parameters->FindParam(&dim,"dim");
	if (dim==3){ 
		IoModelFetchData(&temperature,NULL,NULL,iomodel_handle,"temperature");
		
		count++;
		param= new Param(count,"t_g",DOUBLEVEC);
		if(temperature) param->SetDoubleVec(temperature,iomodel->numberofnodes,1);
		else param->SetDoubleVec(temperature,0,0);
		parameters->AddObject(param);

		/*Free temperature: */
		xfree((void**)&temperature);
	}

	/*Get thickness: */
	IoModelFetchData(&thickness,NULL,NULL,iomodel_handle,"thickness");
	
	count++;
	param= new Param(count,"h_g",DOUBLEVEC);
	if(thickness) param->SetDoubleVec(thickness,iomodel->numberofnodes,1);
	else param->SetDoubleVec(thickness,0,0);
	parameters->AddObject(param);

	/*Free thickness: */
	xfree((void**)&thickness);

	/*Get surface: */
	IoModelFetchData(&surface,NULL,NULL,iomodel_handle,"surface");
	
	count++;
	param= new Param(count,"s_g",DOUBLEVEC);
	if(surface) param->SetDoubleVec(surface,iomodel->numberofnodes,1);
	else param->SetDoubleVec(surface,0,0);
	parameters->AddObject(param);

	/*Free surface: */
	xfree((void**)&surface);

	/*Get bed: */
	IoModelFetchData(&bed,NULL,NULL,iomodel_handle,"bed");
	
	count++;
	param= new Param(count,"b_g",DOUBLEVEC);
	if(bed) param->SetDoubleVec(bed,iomodel->numberofnodes,1);
	else param->SetDoubleVec(bed,0,0);
	parameters->AddObject(param);

	/*Free bed: */
	xfree((void**)&bed);

	/*Get melting: */
	IoModelFetchData(&melting,NULL,NULL,iomodel_handle,"melting");
	if(melting) for(i=0;i<iomodel->numberofnodes;i++)melting[i]=melting[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"m_g",DOUBLEVEC);
	if(melting) param->SetDoubleVec(melting,iomodel->numberofnodes,1);
	else param->SetDoubleVec(melting,0,1);
	parameters->AddObject(param);

	/*Free melting: */
	xfree((void**)&melting);

	/*Get accumulation: */
	IoModelFetchData(&accumulation,NULL,NULL,iomodel_handle,"accumulation");
	if(accumulation) for(i=0;i<iomodel->numberofnodes;i++)accumulation[i]=accumulation[i]/iomodel->yts;
	
	count++;
	param= new Param(count,"a_g",DOUBLEVEC);
	if(accumulation) param->SetDoubleVec(accumulation,iomodel->numberofnodes,1);
	else param->SetDoubleVec(accumulation,0,0);
	parameters->AddObject(param);

	/*Free accumulation: */
	xfree((void**)&accumulation);


	/*Assign output pointer: */
	*pparameters=parameters;
}
