#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "GeometricalVertex.h"

namespace bamg {

	/*Constructors/Destructors*/
	//See header file

	/*Methods*/
	/*FUNCTION GeometricalVertex::Corner {{{1*/
	int  GeometricalVertex::Corner() const {
		return cas & 4;
	}
	/*}}}*/
	/*FUNCTION GeometricalVertex::Required {{{1*/
	int  GeometricalVertex::Required()const {
		// a corner is required
		return cas & 6;
	}
	/*}}}*/
	/*FUNCTION GeometricalVertex::IsThe {{{1*/
	int  GeometricalVertex::IsThe() const {
		return link == this;
	}  
	/*}}}*/
	/*FUNCTION GeometricalVertex::SetCorner {{{1*/
	void GeometricalVertex::SetCorner(){
		cas |= 4;
	}
	/*}}}*/
	/*FUNCTION GeometricalVertex::SetRequired {{{1*/
	void GeometricalVertex::SetRequired(){
		cas |= 2;
	}
	/*}}}*/
	/*FUNCTION GeometricalVertex::Set {{{1*/
	void GeometricalVertex::Set(){
		cas=0;
	}
	/*}}}*/
	/*FUNCTION GeometricalVertex::The {{{1*/
	GeometricalVertex* GeometricalVertex::The(){
		// return a unique vertex
		ISSMASSERT(link);
		return link;
	}/*}}}*/

} 
