#include "stdio.h"
#include "./BamgGeom.h"

void BamgGeomInit(BamgGeom* bamggeom){

	bamggeom->VerticesSize[0]=0,  bamggeom->VerticesSize[1]=0;  bamggeom->Vertices=NULL;
	bamggeom->EdgesSize[0]=0,     bamggeom->EdgesSize[1]=0;     bamggeom->Edges=NULL;
	bamggeom->hVertices=NULL;
	bamggeom->MetricVertices=NULL;
	bamggeom->h1h2VpVertices=NULL;
	bamggeom->TangentAtEdgesSize[0]=0,    bamggeom->TangentAtEdgesSize[1]=0;    bamggeom->TangentAtEdges=NULL;
	bamggeom->CornersSize[0]=0,           bamggeom->CornersSize[1]=0;           bamggeom->Corners=NULL;
	bamggeom->RequiredVerticesSize[0]=0,  bamggeom->RequiredVerticesSize[1]=0;  bamggeom->RequiredVertices=NULL;
	bamggeom->RequiredEdgesSize[0]=0,     bamggeom->RequiredEdgesSize[1]=0;     bamggeom->RequiredEdges=NULL;
	bamggeom->CrackedEdgesSize[0]=0,      bamggeom->CrackedEdgesSize[1]=0;      bamggeom->CrackedEdges=NULL;
	bamggeom->SubDomainsSize[0]=0,        bamggeom->SubDomainsSize[1]=0;        bamggeom->SubDomains=NULL;

}

#ifdef _SERIAL_
void BamgGeomWrite(mxArray** pbamggeom_mat, BamgGeom* bamggeom){

	/*Output*/
	mxArray*    bamggeom_mat=NULL;

	/*Intermediary*/
	int         i,j;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;
	int         numfields=7;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	fnames[0] = "Vertices";
	fnames[1] = "Edges";
	fnames[2] = "TangentAtEdges";
	fnames[3] = "RequiredVertices";
	fnames[4] = "RequiredEdges";
	fnames[5] = "CrackedEdges";
	fnames[6] = "SubDomains";

	bamggeom_mat=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamggeom->VerticesSize[1]);
	mxSetN(pfield,bamggeom->VerticesSize[0]);
	mxSetPr(pfield,bamggeom->Vertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"Vertices",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamggeom->EdgesSize[1]);
	mxSetN(pfield,bamggeom->EdgesSize[0]);
	mxSetPr(pfield,bamggeom->Edges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"Edges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamggeom->TangentAtEdgesSize[1]);
	mxSetN(pfield,bamggeom->TangentAtEdgesSize[0]);
	mxSetPr(pfield,bamggeom->TangentAtEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"TangentAtEdges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamggeom->RequiredVerticesSize[1]);
	mxSetN(pfield,bamggeom->RequiredVerticesSize[0]);
	mxSetPr(pfield,bamggeom->RequiredVertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"RequiredVertices",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamggeom->RequiredEdgesSize[1]);
	mxSetN(pfield,bamggeom->RequiredEdgesSize[0]);
	mxSetPr(pfield,bamggeom->RequiredEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"RequiredEdges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamggeom->CrackedEdgesSize[1]);
	mxSetN(pfield,bamggeom->CrackedEdgesSize[0]);
	mxSetPr(pfield,bamggeom->CrackedEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"CrackedEdges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamggeom->SubDomainsSize[1]);
	mxSetN(pfield,bamggeom->SubDomainsSize[0]);
	mxSetPr(pfield,bamggeom->SubDomains);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"SubDomains",pfield2);

	/*Assign output pointer*/
	*pbamggeom_mat=bamggeom_mat;

}
#endif
