#include "stdio.h"
#include "./BamgMesh.h"

void BamgMeshInit(BamgMesh* bamgmesh){

	bamgmesh->TrianglesSize[0]=0,     bamgmesh->TrianglesSize[1]=0;      bamgmesh->Triangles=NULL;
	bamgmesh->VerticesSize[0]=0,      bamgmesh->VerticesSize[1]=0;       bamgmesh->Vertices=NULL;
	bamgmesh->EdgesSize[0]=0,         bamgmesh->EdgesSize[1]=0;          bamgmesh->Edges=NULL;
	bamgmesh->ElementEdgesSize[0]=0,  bamgmesh->ElementEdgesSize[1]=0;   bamgmesh->ElementEdges=NULL;
	bamgmesh->SegmentsSize[0]=0,      bamgmesh->SegmentsSize[1]=0;       bamgmesh->Segments=NULL;
	bamgmesh->CrackedEdgesSize[0]=0,  bamgmesh->CrackedEdgesSize[1]=0;   bamgmesh->CrackedEdges=NULL;
	bamgmesh->QuadrilateralsSize[0]=0,bamgmesh->QuadrilateralsSize[1]=0; bamgmesh->Quadrilaterals=NULL;
	bamgmesh->VerticesOnGeometricVertexSize[0]=0, bamgmesh->VerticesOnGeometricVertexSize[1]=0;bamgmesh->VerticesOnGeometricVertex=NULL;
	bamgmesh->VerticesOnGeometricEdgeSize[0]=0,   bamgmesh->VerticesOnGeometricEdgeSize[1]=0;  bamgmesh->VerticesOnGeometricEdge=NULL;
	bamgmesh->EdgesOnGeometricEdgeSize[0]=0,      bamgmesh->EdgesOnGeometricEdgeSize[1]=0;     bamgmesh->EdgesOnGeometricEdge=NULL;
	bamgmesh->SubDomainsSize[0]=0,         bamgmesh->SubDomainsSize[1]=0;          bamgmesh->SubDomains=NULL;
	bamgmesh->SubDomainsFromGeomSize[0]=0, bamgmesh->SubDomainsFromGeomSize[1]=0;  bamgmesh->SubDomainsFromGeom=NULL;
	bamgmesh->hVertices=NULL;
	bamgmesh->ElementConnectivitySize[0]=0,      bamgmesh->ElementConnectivitySize[1]=0;      bamgmesh->ElementConnectivity=NULL;
	bamgmesh->NodalConnectivitySize[0]=0,        bamgmesh->NodalConnectivitySize[1]=0;        bamgmesh->NodalConnectivity=NULL;
	bamgmesh->NodalElementConnectivitySize[0]=0, bamgmesh->NodalElementConnectivitySize[1]=0; bamgmesh->NodalElementConnectivity=NULL;

}

#ifdef _SERIAL_
void BamgMeshWrite(mxArray** pbamgmesh_mat, BamgMesh* bamgmesh){

	/*Output*/
	mxArray*    bamgmesh_mat=NULL;

	/*Intermediary*/
	int         i,j;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;
	int         numfields=15;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	fnames[0] = "Triangles";
	fnames[1] = "Vertices";
	fnames[2] = "Edges";
	fnames[3] = "Segments";
	fnames[4] = "AllEdges";
	fnames[5] = "CrackedEdges";
	fnames[6] = "Quadrilaterals";
	fnames[7] = "VerticesOnGeometricVertex";
	fnames[8] = "VerticesOnGeometricEdge";
	fnames[9] = "EdgesOnGeometricEdge";
	fnames[10]= "SubDomains";
	fnames[11]= "SubDomainsFromGeom";
	fnames[12]= "ElementConnectivity";
	fnames[13]= "NodalConnectivity";
	fnames[14]= "NodalElementConnectivity";

	bamgmesh_mat=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->TrianglesSize[1]);
	mxSetN(pfield,bamgmesh->TrianglesSize[0]);
	mxSetPr(pfield,bamgmesh->Triangles);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");
	mxSetField(bamgmesh_mat,0,"Triangles",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->VerticesSize[1]);
	mxSetN(pfield,bamgmesh->VerticesSize[0]);
	mxSetPr(pfield,bamgmesh->Vertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");
	mxSetField(bamgmesh_mat,0,"Vertices",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->EdgesSize[1]);
	mxSetN(pfield,bamgmesh->EdgesSize[0]);
	mxSetPr(pfield,bamgmesh->Edges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");
	mxSetField(bamgmesh_mat,0,"Edges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->SegmentsSize[1]);
	mxSetN(pfield,bamgmesh->SegmentsSize[0]);
	mxSetPr(pfield,bamgmesh->Segments);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");
	mxSetField(bamgmesh_mat,0,"Segments",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->ElementEdgesSize[1]);
	mxSetN(pfield,bamgmesh->ElementEdgesSize[0]);
	mxSetPr(pfield,bamgmesh->ElementEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");
	mxSetField(bamgmesh_mat,0,"AllEdges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->CrackedEdgesSize[1]);
	mxSetN(pfield,bamgmesh->CrackedEdgesSize[0]);
	mxSetPr(pfield,bamgmesh->CrackedEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");
	mxSetField(bamgmesh_mat,0,"CrackedEdges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->QuadrilateralsSize[1]);
	mxSetN(pfield,bamgmesh->QuadrilateralsSize[0]);
	mxSetPr(pfield,bamgmesh->Quadrilaterals);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");
	mxSetField(bamgmesh_mat,0,"Quadrilaterals",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->VerticesOnGeometricVertexSize[1]);
	mxSetN(pfield,bamgmesh->VerticesOnGeometricVertexSize[0]);
	mxSetPr(pfield,bamgmesh->VerticesOnGeometricVertex);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"VerticesOnGeometricVertex",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->VerticesOnGeometricEdgeSize[1]);
	mxSetN(pfield,bamgmesh->VerticesOnGeometricEdgeSize[0]);
	mxSetPr(pfield,bamgmesh->VerticesOnGeometricEdge);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"VerticesOnGeometricEdge",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->EdgesOnGeometricEdgeSize[1]);
	mxSetN(pfield,bamgmesh->EdgesOnGeometricEdgeSize[0]);
	mxSetPr(pfield,bamgmesh->EdgesOnGeometricEdge);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"EdgesOnGeometricEdge",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->SubDomainsSize[1]);
	mxSetN(pfield,bamgmesh->SubDomainsSize[0]);
	mxSetPr(pfield,bamgmesh->SubDomains);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"SubDomains",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->SubDomainsFromGeomSize[1]);
	mxSetN(pfield,bamgmesh->SubDomainsFromGeomSize[0]);
	mxSetPr(pfield,bamgmesh->SubDomainsFromGeom);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"SubDomainsFromGeom",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->ElementConnectivitySize[1]);
	mxSetN(pfield,bamgmesh->ElementConnectivitySize[0]);
	mxSetPr(pfield,bamgmesh->ElementConnectivity);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"ElementConnectivity",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->NodalConnectivitySize[1]);
	mxSetN(pfield,bamgmesh->NodalConnectivitySize[0]);
	mxSetPr(pfield,bamgmesh->NodalConnectivity);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"NodalConnectivity",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->NodalElementConnectivitySize[1]);
	mxSetN(pfield,bamgmesh->NodalElementConnectivitySize[0]);
	mxSetPr(pfield,bamgmesh->NodalElementConnectivity);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"NodalElementConnectivity",pfield2);

	/*Assign output pointer*/
	*pbamgmesh_mat=bamgmesh_mat;
}
#endif
