/*!\file:  BamgGeom.h
 */ 

#ifndef BAMGGEOM_H_
#define BAMGGEOM_H_

struct BamgGeom{

	int     VerticesSize[2];
	double* Vertices;

	int     EdgesSize[2];
	double* Edges;

	double* hVertices;
	double* MetricVertices;
	double* h1h2VpVertices;

	int     TangentAtEdgesSize[2];
	double* TangentAtEdges;

	int     CornersSize[2];
	double* Corners;

	int     RequiredVerticesSize[2];
	double* RequiredVertices;

	int     RequiredEdgesSize[2];
	double* RequiredEdges;

	int     CrackedEdgesSize[2];
	double* CrackedEdges;

	int     SubDomainsSize[2];
	double* SubDomains;
};

void BamgGeomInit(BamgGeom* bamggeom);

#ifdef _SERIAL_
#include "mex.h"
void BamgGeomWrite(mxArray** bamggeom_mat,BamgGeom* bamggeom);
#endif

#endif
