function bm = bamgmesh(varargin)
%ICEFRONT - constructor for bamgmesh object
%
%   Usage:
%      bamgmesh = bamgmesh(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	bm.Vertices=[];
	bm.Edges=[];
	bm.Triangles=[];
	bm.Quadrilaterals=[];
	bm.AllEdges=[];
	bm.Segments=[];
	bm.VerticesOnGeometricVertex=[];
	bm.VerticesOnGeometricEdge=[];
	bm.EdgesOnGeometricEdge=[];
	bm.CrackedEdges=[];
	bm.SubDomains=[];
	bm.SubDomainsFromGeom=[];
	bm.ElementConnectivity=[];
	bm.NodalConnectivity=[];
	bm.NodalElementConnectivity=[];
	bm.hVertices=[];

	bm=class(bm,'bamgmesh');

case 1

	bm=bamgmesh;
	object=varargin{1};
	fields=fieldnames(object);
	for i=1:length(fields)
		field=fields{i};
		if isfield(struct(bm),field),
			bm.(field)=object.(field);
		end
	end

otherwise
	error('bamgmesh constructor error message: unknown type of constructor call');
end
