#include "stdio.h"
#include "./BamgMesh.h"

void BamgMeshInit(BamgMesh* bamgmesh){

	bamgmesh->NumTriangles=0;
	bamgmesh->Triangles=NULL;
	bamgmesh->NumVertices=0;
	bamgmesh->Vertices=NULL;
	bamgmesh->NumEdges=0;
	bamgmesh->Edges=NULL;
	bamgmesh->NumAllEdges=0;
	bamgmesh->AllEdges=NULL;
	bamgmesh->NumSegments=0;
	bamgmesh->Segments=NULL;
	bamgmesh->SegmentsMarkers=NULL;
	bamgmesh->NumCrackedEdges=0;
	bamgmesh->CrackedEdges=NULL;
	bamgmesh->NumQuadrilaterals=0;
	bamgmesh->Quadrilaterals=NULL;
	bamgmesh->NumVerticesOnGeometricVertex=0;
	bamgmesh->VerticesOnGeometricVertex=NULL;
	bamgmesh->NumVerticesOnGeometricEdge=0;
	bamgmesh->VerticesOnGeometricEdge=NULL;
	bamgmesh->NumEdgesOnGeometricEdge=0;
	bamgmesh->EdgesOnGeometricEdge=NULL;
	bamgmesh->NumSubDomains=0;
	bamgmesh->SubDomains=NULL;
	bamgmesh->NumSubDomainsFromGeom=0;
	bamgmesh->SubDomainsFromGeom=NULL;
	bamgmesh->hVertices=NULL;
	bamgmesh->NumElementConnectivity=0;
	bamgmesh->ElementConnectivity=NULL;
	bamgmesh->NumNodalConnectivity=0;
	bamgmesh->NodalConnectivity=NULL;
	bamgmesh->NumNodalElementConnectivity=0;
	bamgmesh->NodalElementConnectivity=NULL;

}

#ifdef _SERIAL_
void BamgMeshWrite(mxArray** pbamgmesh_mat, BamgMesh* bamgmesh){

	/*Output*/
	mxArray*    bamgmesh_mat=NULL;

	/*Intermediary*/
	int         i,j;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;
	int         numfields=15;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	fnames[0]  = "Triangles";
	fnames[1]  = "Vertices";
	fnames[2]  = "Edges";
	fnames[3]  = "Segments";
	fnames[4]  = "AllEdges";
	fnames[5] = "CrackedEdges";
	fnames[6] = "Quadrilaterals";
	fnames[7] = "VerticesOnGeometricVertex";
	fnames[8] = "VerticesOnGeometricEdge";
	fnames[9] = "EdgesOnGeometricEdge";
	fnames[10]= "SubDomains";
	fnames[11]= "SubDomainsFromGeom";
	fnames[12]= "ElementConnectivity";
	fnames[13]= "NodalConnectivity";
	fnames[14]= "NodalElementConnectivity";

	bamgmesh_mat=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	mxSetField(bamgmesh_mat,0,"NumTriangles",mxCreateDoubleScalar(bamgmesh->NumTriangles)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh->NumTriangles);
	mxSetPr(pfield,bamgmesh->Triangles);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"Triangles",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh->NumVertices);
	mxSetPr(pfield,bamgmesh->Vertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"Vertices",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh->NumEdges);
	mxSetPr(pfield,bamgmesh->Edges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"Edges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh->NumSegments);
	mxSetPr(pfield,bamgmesh->Segments);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"Segments",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh->NumAllEdges);
	mxSetPr(pfield,bamgmesh->AllEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"AllEdges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh->NumCrackedEdges);
	mxSetPr(pfield,bamgmesh->CrackedEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"CrackedEdges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,5);
	mxSetN(pfield,bamgmesh->NumQuadrilaterals);
	mxSetPr(pfield,bamgmesh->Quadrilaterals);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"Quadrilaterals",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh->NumVerticesOnGeometricVertex);
	mxSetPr(pfield,bamgmesh->VerticesOnGeometricVertex);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"VerticesOnGeometricVertex",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh->NumVerticesOnGeometricEdge);
	mxSetPr(pfield,bamgmesh->VerticesOnGeometricEdge);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"VerticesOnGeometricEdge",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh->NumEdgesOnGeometricEdge);
	mxSetPr(pfield,bamgmesh->EdgesOnGeometricEdge);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"EdgesOnGeometricEdge",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh->NumSubDomains);
	mxSetPr(pfield,bamgmesh->SubDomains);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"SubDomains",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh->NumSubDomainsFromGeom);
	mxSetPr(pfield,bamgmesh->SubDomainsFromGeom);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"SubDomainsFromGeom",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh->NumElementConnectivity);
	mxSetPr(pfield,bamgmesh->ElementConnectivity);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"ElementConnectivity",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh->NumNodalConnectivity);
	mxSetPr(pfield,bamgmesh->NodalConnectivity);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"NodalConnectivity",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,bamgmesh->NumNodalElementConnectivity);
	mxSetN(pfield,bamgmesh->NumVertices);
	mxSetPr(pfield,bamgmesh->NodalElementConnectivity);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"NodalElementConnectivity",pfield2);

	/*Assign output pointer*/
	*pbamgmesh_mat=bamgmesh_mat;
}
#endif
