#include "stdio.h"
#include "./BamgGeom.h"

void BamgGeomInit(BamgGeom* bamggeom){

	bamggeom->NumVertices=0;
	bamggeom->Vertices=NULL;
	bamggeom->NumEdges=0;
	bamggeom->Edges=NULL;
	bamggeom->hVertices=NULL;
	bamggeom->MetricVertices=NULL;
	bamggeom->h1h2VpVertices=NULL;
	bamggeom->NumTangentAtEdges=0;
	bamggeom->TangentAtEdges=NULL;
	bamggeom->NumCorners=0;
	bamggeom->Corners=NULL;
	bamggeom->NumRequiredVertices=0;
	bamggeom->RequiredVertices=NULL;
	bamggeom->NumRequiredEdges=0;
	bamggeom->RequiredEdges=NULL;
	bamggeom->NumCrackedEdges=0;
	bamggeom->CrackedEdges=NULL;
	bamggeom->NumSubDomains=0;
	bamggeom->SubDomains=NULL;

}

#ifdef _SERIAL_
void BamgGeomWrite(mxArray** pbamggeom_mat, BamgGeom* bamggeom){

	/*Output*/
	mxArray*    bamggeom_mat=NULL;

	/*Intermediary*/
	int         i,j;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;
	int         numfields=7;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	fnames[0] = "Vertices";
	fnames[1] = "Edges";
	fnames[2] = "TangentAtEdges";
	fnames[3] = "RequiredVertices";
	fnames[4] = "RequiredEdges";
	fnames[5] = "CrackedEdges";
	fnames[6] = "SubDomains";

	bamggeom_mat=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamggeom->NumVertices);
	mxSetPr(pfield,bamggeom->Vertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"Vertices",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamggeom->NumEdges);
	mxSetPr(pfield,bamggeom->Edges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"Edges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamggeom->NumTangentAtEdges);
	mxSetPr(pfield,bamggeom->TangentAtEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"TangentAtEdges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,1);
	mxSetN(pfield,bamggeom->NumRequiredVertices);
	mxSetPr(pfield,bamggeom->RequiredVertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"RequiredVertices",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,1);
	mxSetN(pfield,bamggeom->NumRequiredEdges);
	mxSetPr(pfield,bamggeom->RequiredEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"RequiredEdges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamggeom->NumCrackedEdges);
	mxSetPr(pfield,bamggeom->CrackedEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"CrackedEdges",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamggeom->NumSubDomains);
	mxSetPr(pfield,bamggeom->SubDomains);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"SubDomains",pfield2);

	/*Assign output pointer*/
	*pbamggeom_mat=bamggeom_mat;

}
#endif
