/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*Outputs*/
	mxArray* bamgmesh_mat=NULL;
	mxArray* bamggeom_mat=NULL;

	/*diverse: */
	int   noerr=1;
	int   i;
	int   lines,cols;
	BamgOpts bamgopts;
	BamgMesh bamgmesh_in,bamgmesh_out;
	BamgGeom bamggeom_in,bamggeom_out;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*create bamg geometry input*/
	BamgGeomInit(&bamggeom_in);
	FetchData(&bamggeom_in.NumVertices,mxGetField(BAMGGEOMETRY,0,"NumVertices"));
	FetchData(&bamggeom_in.Vertices,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Vertices"));
	FetchData(&bamggeom_in.NumEdges,mxGetField(BAMGGEOMETRY,0,"NumEdges"));
	FetchData(&bamggeom_in.Edges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Edges"));
	FetchData(&bamggeom_in.NumCorners,mxGetField(BAMGGEOMETRY,0,"NumCorners"));
	FetchData(&bamggeom_in.Corners,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Corners"));
	FetchData(&bamggeom_in.NumRequiredVertices,mxGetField(BAMGGEOMETRY,0,"NumRequiredVertices"));
	FetchData(&bamggeom_in.RequiredVertices,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"RequiredVertices"));
	FetchData(&bamggeom_in.NumRequiredEdges,mxGetField(BAMGGEOMETRY,0,"NumRequiredEdges"));
	FetchData(&bamggeom_in.RequiredEdges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"RequiredEdges"));
	FetchData(&bamggeom_in.hVertices,&lines,&cols,mxGetField(BAMGGEOMETRY,0,"hVertices"));
	FetchData(&bamggeom_in.NumCrackedEdges,mxGetField(BAMGGEOMETRY,0,"NumCrackedEdges"));
	FetchData(&bamggeom_in.CrackedEdges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"CrackedEdges"));
	FetchData(&bamggeom_in.NumSubDomains,mxGetField(BAMGGEOMETRY,0,"NumSubDomains"));
	FetchData(&bamggeom_in.SubDomains,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"SubDomains"));
	if (bamggeom_in.hVertices && (cols!=1 || lines!=bamggeom_in.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'hVertices' should be [%i %i]",bamggeom_in.NumVertices,1));}

	/*create bamg mesh input*/
	BamgMeshInit(&bamgmesh_in);
	FetchData(&bamgmesh_in.NumVertices,mxGetField(BAMGMESH,0,"NumVertices"));
	FetchData(&bamgmesh_in.Vertices,NULL,NULL,mxGetField(BAMGMESH,0,"Vertices"));
	FetchData(&bamgmesh_in.NumTriangles,mxGetField(BAMGMESH,0,"NumTriangles"));
	FetchData(&bamgmesh_in.Triangles,NULL,NULL,mxGetField(BAMGMESH,0,"Triangles"));
	FetchData(&bamgmesh_in.hVertices,&lines,&cols,mxGetField(BAMGMESH,0,"hVertices"));
	FetchData(&bamgmesh_in.NumSegments,mxGetField(BAMGMESH,0,"NumSegments"));
	FetchData(&bamgmesh_in.Segments,NULL,NULL,mxGetField(BAMGMESH,0,"Segments"));
	FetchData(&bamgmesh_in.SegmentsMarkers,NULL,NULL,mxGetField(BAMGMESH,0,"SegmentsMarkers"));
	FetchData(&bamgmesh_in.NumCrackedEdges,mxGetField(BAMGMESH,0,"NumCrackedEdges"));
	FetchData(&bamgmesh_in.CrackedEdges,NULL,NULL,mxGetField(BAMGMESH,0,"CrackedEdges"));
	FetchData(&bamgmesh_in.NumEdges,mxGetField(BAMGMESH,0,"NumEdges"));
	FetchData(&bamgmesh_in.Edges,NULL,NULL,mxGetField(BAMGMESH,0,"Edges"));
	FetchData(&bamgmesh_in.NumEdgesOnGeometricEdge,mxGetField(BAMGMESH,0,"NumEdgesOnGeometricEdge"));
	FetchData(&bamgmesh_in.EdgesOnGeometricEdge,NULL,NULL,mxGetField(BAMGMESH,0,"EdgesOnGeometricEdge"));
	FetchData(&bamgmesh_in.NumVerticesOnGeometricEdge,mxGetField(BAMGMESH,0,"NumVerticesOnGeometricEdge"));
	FetchData(&bamgmesh_in.VerticesOnGeometricEdge,NULL,NULL,mxGetField(BAMGMESH,0,"VerticesOnGeometricEdge"));
	FetchData(&bamgmesh_in.NumVerticesOnGeometricVertex,mxGetField(BAMGMESH,0,"NumVerticesOnGeometricVertex"));
	FetchData(&bamgmesh_in.VerticesOnGeometricVertex,NULL,NULL,mxGetField(BAMGMESH,0,"VerticesOnGeometricVertex"));
	if (bamgmesh_in.hVertices && (cols!=1 || lines!=bamgmesh_in.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'hVertices' should be [%i %i]",bamgmesh_in.NumVertices,1));}

	/*create bamg options input*/
	BamgOptsInit(&bamgopts);
	FetchData(&bamgopts.coef,mxGetField(BAMGOPTIONS,0,"coef"));
	FetchData(&bamgopts.maxsubdiv,mxGetField(BAMGOPTIONS,0,"maxsubdiv"));
	FetchData(&bamgopts.Hessiantype,mxGetField(BAMGOPTIONS,0,"Hessiantype"));
	FetchData(&bamgopts.Metrictype,mxGetField(BAMGOPTIONS,0,"Metrictype"));
	FetchData(&bamgopts.KeepVertices,mxGetField(BAMGOPTIONS,0,"KeepVertices"));
	FetchData(&bamgopts.power,mxGetField(BAMGOPTIONS,0,"power"));
	FetchData(&bamgopts.errg,mxGetField(BAMGOPTIONS,0,"errg"));
	FetchData(&bamgopts.nbjacobi,mxGetField(BAMGOPTIONS,0,"nbjacobi"));
	FetchData(&bamgopts.NbSmooth,mxGetField(BAMGOPTIONS,0,"NbSmooth"));
	FetchData(&bamgopts.omega,mxGetField(BAMGOPTIONS,0,"omega"));
	FetchData(&bamgopts.maxnbv,mxGetField(BAMGOPTIONS,0,"maxnbv"));
	FetchData(&bamgopts.hmin,mxGetField(BAMGOPTIONS,0,"hmin"));
	FetchData(&bamgopts.hmax,mxGetField(BAMGOPTIONS,0,"hmax"));
	FetchData(&bamgopts.anisomax,mxGetField(BAMGOPTIONS,0,"anisomax"));
	FetchData(&bamgopts.gradation,mxGetField(BAMGOPTIONS,0,"gradation"));
	FetchData(&bamgopts.cutoff,mxGetField(BAMGOPTIONS,0,"cutoff"));
	FetchData(&bamgopts.verbose,mxGetField(BAMGOPTIONS,0,"verbose"));
	FetchData(&bamgopts.splitcorners,mxGetField(BAMGOPTIONS,0,"splitcorners"));
	FetchData(&bamgopts.geometricalmetric,mxGetField(BAMGOPTIONS,0,"geometricalmetric"));
	FetchData(&bamgopts.MaximalAngleOfCorner,mxGetField(BAMGOPTIONS,0,"MaximalAngleOfCorner"));
	FetchData(&bamgopts.hminVertices,&lines,&cols,mxGetField(BAMGOPTIONS,0,"hminVertices"));
	if (bamgopts.hminVertices && (cols!=1 || lines!=bamgmesh_in.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'hminVertices' should be [%i %i]",bamgmesh_in.NumVertices,1));}
	FetchData(&bamgopts.hmaxVertices,&lines,&cols,mxGetField(BAMGOPTIONS,0,"hmaxVertices"));
	if (bamgopts.hmaxVertices && (cols!=1 || lines!=bamgmesh_in.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'hmaxVertices' should be [%i %i]",bamgmesh_in.NumVertices,1));}
	FetchData(&bamgopts.metric,&lines,&cols,mxGetField(BAMGOPTIONS,0,"metric"));
	if (bamgopts.metric && (cols!=3 || lines!=bamgmesh_in.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'metric' should be [%i %i]",bamgmesh_in.NumVertices,3));}
	FetchData(&bamgopts.field,&lines,&bamgopts.numfields,mxGetField(BAMGOPTIONS,0,"field"));
	if (bamgopts.field && lines!=bamgmesh_in.NumVertices){throw ErrorException(__FUNCT__,exprintf("the size of 'field' should be [%i %i]",bamgmesh_in.NumVertices,bamgopts.numfields));}
	FetchData(&bamgopts.err,NULL,&cols,mxGetField(BAMGOPTIONS,0,"err"));
	if (bamgopts.numfields!=0 && cols!=bamgopts.numfields){throw ErrorException(__FUNCT__,exprintf("the size of 'err' should be the same as 'field'"));}
	BamgOptsCheck(&bamgopts);

	/*!Generate internal degree of freedom numbers: */
	Bamgx(&bamgmesh_out,&bamggeom_out,&bamgmesh_in,&bamggeom_in,&bamgopts);

	/*Generate output Matlab Structures*/
	BamgMeshWrite(&bamgmesh_mat,&bamgmesh_out);
	BamgGeomWrite(&bamggeom_mat,&bamggeom_out);

	/*assign output datasets: */
	*BAMGMESHOUT=bamgmesh_mat;
	*BAMGGEOMOUT=bamggeom_mat;

	/*Free ressources: */
	//do not free any fields of bamgmesh or bamggeom as it has been freed in bamgx

	/*end module: */
	MODULEEND();
}

void BamgUsage(void){
	_printf_("\n");
	_printf_("   usage: [bamgmesh,bamggeom]=%s(bamgmesh,bamggeom,bamgoptions);\n",__FUNCT__);
	_printf_("\n");
}
