function expbox(filename)
%EXPBOX - Create a ARGUS file using to clicks
%
%   Two clicks on a plot are used to generate a rectangular box
%   This box is written in EXP format on filename
%
%   Usage:
%      expbox(filename)

%check
if exist(filename,'file'),
	choice=input(['A file ' filename ' already exists, do you want to modify it? (y/n)'],'s');
	if ~strcmpi(choice,'y'),
		disp('no modification done ... exiting');
		return
	end
end

%Get points
disp('Click twice to define a rectangular domain. First click for upper left corner, second for lower right corner');
[x,y]=ginput(2);

%Build Exp structure
A=struct();
A.nods=5;
A.density=1;
A.x=[x(1) x(2) x(2) x(1) x(1)]';
A.y=[y(1) y(1) y(2) y(2) y(1)]';

%Write structure
expwrite(A,filename);
