#ifdef _SERIAL_
#include "stdio.h"
#include "mex.h"
#include "./BamgMesh.h"

void BamgMeshInit(BamgMesh* bamgmesh){

	bamgmesh->NumTriangles=0;
	bamgmesh->Triangles=NULL;
	bamgmesh->NumVertices=0;
	bamgmesh->Vertices=NULL;
	bamgmesh->NumEdges=0;
	bamgmesh->Edges=NULL;
	bamgmesh->NumSegments=0;
	bamgmesh->Segments=NULL;
	bamgmesh->SegmentsMarkers=NULL;
	bamgmesh->NumCrackedEdges=0;
	bamgmesh->CrackedEdges=NULL;
	bamgmesh->NumQuadrilaterals=0;
	bamgmesh->Quadrilaterals=NULL;
	bamgmesh->NumVerticesOnGeometricVertex=0;
	bamgmesh->VerticesOnGeometricVertex=NULL;
	bamgmesh->NumVerticesOnGeometricEdge=0;
	bamgmesh->VerticesOnGeometricEdge=NULL;
	bamgmesh->NumEdgesOnGeometricEdge=0;
	bamgmesh->EdgesOnGeometricEdge=NULL;
	bamgmesh->NumSubDomains=0;
	bamgmesh->SubDomains=NULL;
	bamgmesh->NumSubDomainsFromGeom=0;
	bamgmesh->SubDomainsFromGeom=NULL;
	bamgmesh->hVertices=NULL;

}

void BamgMeshWrite(mxArray** pbamgmesh_mat, BamgMesh* bamgmesh){

	/*Output*/
	mxArray*    bamgmesh_mat=NULL;

	/*Intermediary*/
	int         i,j;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;
	int         numfields=23;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	fnames[0] = "NumTriangles";
	fnames[1] = "Triangles";
	fnames[2] = "NumVertices";
	fnames[3] = "Vertices";
	fnames[4] = "NumEdges";
	fnames[5] = "Edges";
	fnames[6] = "NumSegments";
	fnames[7] = "Segments";
	fnames[8] = "SegmentsMarkers";
	fnames[9] = "NumCrackedEdges";
	fnames[10] = "CrackedEdges";
	fnames[11] = "NumQuadrilaterals";
	fnames[12] = "Quadrilaterals";
	fnames[13] = "NumVerticesOnGeometricVertex";
	fnames[14] = "VerticesOnGeometricVertex";
	fnames[15] = "NumVerticesOnGeometricEdge";
	fnames[16] = "VerticesOnGeometricEdge";
	fnames[17] = "NumEdgesOnGeometricEdge";
	fnames[18] = "EdgesOnGeometricEdge";
	fnames[19] = "NumSubDomains";
	fnames[20] = "SubDomains";
	fnames[21] = "NumSubDomainsFromGeom";
	fnames[22] = "SubDomainsFromGeom";

	bamgmesh_mat=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	mxSetField(bamgmesh_mat,0,"NumTriangles",mxCreateDoubleScalar(bamgmesh->NumTriangles)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh->NumTriangles);
	mxSetPr(pfield,bamgmesh->Triangles);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"Triangles",pfield2);

	mxSetField(bamgmesh_mat,0,"NumVertices",mxCreateDoubleScalar(bamgmesh->NumVertices)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh->NumVertices);
	mxSetPr(pfield,bamgmesh->Vertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"Vertices",pfield2);

	mxSetField(bamgmesh_mat,0,"NumEdges",mxCreateDoubleScalar(bamgmesh->NumEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh->NumEdges);
	mxSetPr(pfield,bamgmesh->Edges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"Edges",pfield2);

	mxSetField(bamgmesh_mat,0,"NumSegments",mxCreateDoubleScalar(bamgmesh->NumSegments)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh->NumSegments);
	mxSetPr(pfield,bamgmesh->Segments);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"Segments",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,1);
	mxSetN(pfield,bamgmesh->NumSegments);
	mxSetPr(pfield,bamgmesh->SegmentsMarkers);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"SegmentsMarkers",pfield2);

	mxSetField(bamgmesh_mat,0,"NumCrackedEdges",mxCreateDoubleScalar(bamgmesh->NumCrackedEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh->NumCrackedEdges);
	mxSetPr(pfield,bamgmesh->CrackedEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"CrackedEdges",pfield2);

	mxSetField(bamgmesh_mat,0,"NumQuadrilaterals",mxCreateDoubleScalar(bamgmesh->NumQuadrilaterals)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,5);
	mxSetN(pfield,bamgmesh->NumQuadrilaterals);
	mxSetPr(pfield,bamgmesh->Quadrilaterals);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"Quadrilaterals",pfield2);

	mxSetField(bamgmesh_mat,0,"NumVerticesOnGeometricVertex",mxCreateDoubleScalar(bamgmesh->NumVerticesOnGeometricVertex)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh->NumVerticesOnGeometricVertex);
	mxSetPr(pfield,bamgmesh->VerticesOnGeometricVertex);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"VerticesOnGeometricVertex",pfield2);

	mxSetField(bamgmesh_mat,0,"NumVerticesOnGeometricEdge",mxCreateDoubleScalar(bamgmesh->NumVerticesOnGeometricEdge)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh->NumVerticesOnGeometricEdge);
	mxSetPr(pfield,bamgmesh->VerticesOnGeometricEdge);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"VerticesOnGeometricEdge",pfield2);

	mxSetField(bamgmesh_mat,0,"NumEdgesOnGeometricEdge",mxCreateDoubleScalar(bamgmesh->NumEdgesOnGeometricEdge)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh->NumEdgesOnGeometricEdge);
	mxSetPr(pfield,bamgmesh->EdgesOnGeometricEdge);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"EdgesOnGeometricEdge",pfield2);

	mxSetField(bamgmesh_mat,0,"NumSubDomains",mxCreateDoubleScalar(bamgmesh->NumSubDomains)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh->NumSubDomains);
	mxSetPr(pfield,bamgmesh->SubDomains);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"SubDomains",pfield2);

	mxSetField(bamgmesh_mat,0,"NumSubDomainsFromGeom",mxCreateDoubleScalar(bamgmesh->NumSubDomainsFromGeom)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh->NumSubDomainsFromGeom);
	mxSetPr(pfield,bamgmesh->SubDomainsFromGeom);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamgmesh_mat,0,"SubDomainsFromGeom",pfield2);

	/*Assign output pointer*/
	*pbamgmesh_mat=bamgmesh_mat;
}
#endif
