#ifdef _SERIAL_
#include "mex.h"
#include "stdio.h"
#include "./BamgGeom.h"

void BamgGeomInit(BamgGeom* bamggeom){

	bamggeom->NumVertices=0;
	bamggeom->Vertices=NULL;
	bamggeom->NumEdges=0;
	bamggeom->Edges=NULL;
	bamggeom->hVertices=NULL;
	bamggeom->MetricVertices=NULL;
	bamggeom->h1h2VpVertices=NULL;
	bamggeom->NumTangentAtEdges=0;
	bamggeom->TangentAtEdges=NULL;
	bamggeom->NumCorners=0;
	bamggeom->Corners=NULL;
	bamggeom->NumRequiredVertices=0;
	bamggeom->RequiredVertices=NULL;
	bamggeom->NumRequiredEdges=0;
	bamggeom->RequiredEdges=NULL;
	bamggeom->NumCrackedEdges=0;
	bamggeom->CrackedEdges=NULL;
	bamggeom->NumSubDomains=0;
	bamggeom->SubDomains=NULL;

}

void BamgGeomWrite(mxArray** pbamggeom_mat, BamgGeom* bamggeom){

	/*Output*/
	mxArray*    bamggeom_mat=NULL;

	/*Intermediary*/
	int         i,j;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;
	int         numfields=14;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	fnames[0] = "NumVertices";
	fnames[1] = "Vertices";
	fnames[2] = "NumEdges";
	fnames[3] = "Edges";
	fnames[4] = "NumTangentAtEdges";
	fnames[5] = "TangentAtEdges";
	fnames[6] = "NumRequiredVertices";
	fnames[7] = "RequiredVertices";
	fnames[8] = "NumRequiredEdges";
	fnames[9] = "RequiredEdges";
	fnames[10]= "NumCrackedEdges";
	fnames[11]= "CrackedEdges";
	fnames[12]= "NumSubDomains";
	fnames[13]= "SubDomains";

	bamggeom_mat=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	mxSetField(bamggeom_mat,0,"NumVertices",mxCreateDoubleScalar(bamggeom->NumVertices)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamggeom->NumVertices);
	mxSetPr(pfield,bamggeom->Vertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"Vertices",pfield2);

	mxSetField(bamggeom_mat,0,"NumEdges",mxCreateDoubleScalar(bamggeom->NumEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamggeom->NumEdges);
	mxSetPr(pfield,bamggeom->Edges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"Edges",pfield2);

	mxSetField(bamggeom_mat,0,"NumTangentAtEdges",mxCreateDoubleScalar(bamggeom->NumTangentAtEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamggeom->NumTangentAtEdges);
	mxSetPr(pfield,bamggeom->TangentAtEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"TangentAtEdges",pfield2);

	mxSetField(bamggeom_mat,0,"NumRequiredVertices",mxCreateDoubleScalar(bamggeom->NumRequiredVertices)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,1);
	mxSetN(pfield,bamggeom->NumRequiredVertices);
	mxSetPr(pfield,bamggeom->RequiredVertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"RequiredVertices",pfield2);

	mxSetField(bamggeom_mat,0,"NumRequiredEdges",mxCreateDoubleScalar(bamggeom->NumRequiredEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,1);
	mxSetN(pfield,bamggeom->NumRequiredEdges);
	mxSetPr(pfield,bamggeom->RequiredEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"RequiredEdges",pfield2);

	mxSetField(bamggeom_mat,0,"NumCrackedEdges",mxCreateDoubleScalar(bamggeom->NumCrackedEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamggeom->NumCrackedEdges);
	mxSetPr(pfield,bamggeom->CrackedEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"CrackedEdges",pfield2);

	mxSetField(bamggeom_mat,0,"NumSubDomains",mxCreateDoubleScalar(bamggeom->NumSubDomains)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamggeom->NumSubDomains);
	mxSetPr(pfield,bamggeom->SubDomains);
	mexCallMATLAB(1,&pfield2,1,&pfield,"transpose");//transpose
	mxSetField(bamggeom_mat,0,"SubDomains",pfield2);

	/*Assign output pointer*/
	*pbamggeom_mat=bamggeom_mat;

}
#endif
