#ifndef _CRACKEDEDGE_H_
#define _CRACKEDEDGE_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../include/typedefs.h"
#include "../include/macros.h"
#include "Vertex.h"
#include "TriangleAdjacent.h"
#include "Edge.h"
#include "Triangle.h"

namespace bamg {

	//classes
	class Triangles;

	class CrackedEdge {

		friend class Triangles;

		class CrackedTriangle {
			friend class Triangles;
			friend class CrackedEdge;
			Triangle* t; // edge of triangle t
			int i;       //  edge number of in triangle
			Edge *edge;  // the  2 edge 
			Vertex *New[2]; // new vertex number 

			//Constructors
			CrackedTriangle() : t(0),i(0),edge(0) { New[0]=New[1]=0;} 
			CrackedTriangle(Edge * a) : t(0),i(0),edge(a) { New[0]=New[1]=0;} 

			//Methods
			void Crack();
			void UnCrack();
			void Set();
		};

		public:  
			CrackedTriangle a,b; 

			//Constructors
			CrackedEdge() :a(),b() {}
			CrackedEdge(Edge * start, long  i,long j) : a(start+i),b(start+j) {};
			CrackedEdge(Edge * e0, Edge * e1 ) : a(e0),b(e1) {};

			//Methods
			void Crack();
			void UnCrack();
			void Set();
	};

	/*Intermediary*/
	inline TriangleAdjacent FindTriangleAdjacent(Edge &E){
		/*Original code from Frederic Hecht <hecht@ann.jussieu.fr> (BAMG v1.01, Mesh2.cpp)*/

		Vertex * a = E.v[0];
		Vertex * b = E.v[1];

		Triangle * t = a->t;
		int i = a->vint;
		TriangleAdjacent ta(t,EdgesVertexTriangle[i][0]); // Previous edge
		if (!t || i<0 || i>=3){
			throw ErrorException(__FUNCT__,exprintf("!t || i<0 !! i>=3"));
		}
		if ( a!=(*t)(i)){
			throw ErrorException(__FUNCT__,exprintf("a!=(*t)(i)"));
		}
		int k=0;
		do { // turn around vertex in direct sens (trigo)
			k++;
			if (k>=20000){
				throw ErrorException(__FUNCT__,exprintf("k>=20000"));
			}
			//  in no crack => ta.EdgeVertex(1) == a otherwise ??? 
			if (ta.EdgeVertex(1) ==  a && ta.EdgeVertex(0) ==  b) return ta; // find 
			ta = ta.Adj();
			if (ta.EdgeVertex(0) ==  a && ta.EdgeVertex(1) ==  b) return ta; // find 
			--ta;
		} while (t != (Triangle *)ta);
		throw ErrorException(__FUNCT__,exprintf("FindTriangleAdjacent: triangle not found"));
		return TriangleAdjacent(0,0);//for compiler
	}
	inline Vertex* TheVertex(Vertex * a){// for remove crak in mesh 
		/*Original code from Frederic Hecht <hecht@ann.jussieu.fr> (BAMG v1.01, Mesh2.cpp)*/

		// give a unique vertex with smallest number
		// in case on crack in mesh 
		Vertex * r(a), *rr;
		Triangle * t = a->t;
		int i = a->vint;
		TriangleAdjacent ta(t,EdgesVertexTriangle[i][0]); // Previous edge
		if (!t || i<0 || i>=3){
			throw ErrorException(__FUNCT__,exprintf("!t || i<0 !! i>=3"));
		}
		if ( a!=(*t)(i)){
			throw ErrorException(__FUNCT__,exprintf("a!=(*t)(i)"));
		}
		int k=0;
		do { // turn around vertex in direct sens (trigo)
			k++;
			if (k>=20000){
				throw ErrorException(__FUNCT__,exprintf("k>=20000"));
			}
			//  in no crack => ta.EdgeVertex(1) == a
			if ((rr=ta.EdgeVertex(0)) < r) r = rr;
			ta = ta.Adj();
			if ((rr=ta.EdgeVertex(1)) < r) r =rr;
			--ta;
		} while (t != (Triangle*) ta);  
		return r;
	}

}
#endif
