#ifndef _TRIANGLEADJACENT_H_
#define _TRIANGLEADJACENT_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../include/typedefs.h"
#include "../include/macros.h"
#include "Vertex.h"

namespace bamg {

	//classes
	class Triangle;

	class TriangleAdjacent {

		public:
			Triangle* t; //pointer toward the triangle
			int  a;      //Edge number

			//Constructors
			TriangleAdjacent() {};
			TriangleAdjacent(Triangle* tt,int  aa): t(tt),a(aa &3) {};

			//Operators
			operator Triangle * () const {return t;}
			operator Triangle & () const {return *t;}
			operator int() const {return a;}
			TriangleAdjacent & operator++(){ a= NextEdge[a]; return *this; }
			TriangleAdjacent operator--(){ a= PreviousEdge[a]; return *this; }

			//Methods

			//Methods
			int  Locked() const;
			int  MarkUnSwap() const;
			int  Cracked() const;
			int  GetAllFlag_UnSwap() const;
			void SetLock();
			void SetCracked();
			void SetAdj2(const TriangleAdjacent &ta, int l=0);
			int  swap();
			TriangleAdjacent Adj() const;
			Vertex* EdgeVertex(const int & i) const;
			Vertex* OppositeVertex() const;
			Icoor2& det() const;
	};
}
#endif

