function md=diagnostic(md);
%DIAGNOSTIC - compute the velocity field of a model
%
%   this routine is a Matlab driven solution
%   
%   Usage:
%      u_g=diagnostic_core_linear(m);
%
%   See also: ICEDIAGNOSTIC2D, ICEDIAGNOSTIC3D, ICEDIAGNOSTIC_CORE_NONLINEAR ICEDIAGNOSTIC_CORE_LINEAR

%start timing
t1=clock;

%define global variables
iceglobal

%Create fem structure (input of diagnostic3d)
fem=struct();

%Figure out which type of elements are present
fem.ishutter=md.ishutter;
fem.ismacayealpattyn=md.ismacayealpattyn;
fem.isstokes=md.isstokes;

if strcmpi(md.type,'2d'),

	%First, build elements,grids,loads, etc ... for horizontal model
	if fem.ishutter,
		fem.m_ss=CreateFemModel(md,'surface_slope_compute');
		fem.m_dhu=CreateFemModel(md,'diagnostic_hutter');
	end
	if fem.ismacayealpattyn,
		fem.m_dh=CreateFemModel(md,'diagnostic_horiz');
	end

	%plug inputs in fem (existing velocity)
	if ~isnan(md.vx) & ~isnan(md.vy) & fem.ismacayealpattyn,
		%an input velocity is present in the model, use it to bootstrap the diagnostic core nonlinear solution.
		m_dh=fem.m_dh;
		fem.inputs.velocity=zeros(m_dh.gridset.gsize,1);
		fem.inputs.velocity(1:6:m_dh.gridset.gsize)=md.vx/md.yts;
		fem.inputs.velocity(2:6:m_dh.gridset.gsize)=md.vy/md.yts;
	else
		fem.inputs=struct();
	end

	%compute solution
	u_g=diagnostic2d(md,fem);

	%Load results onto model
	md=Loadresults(md,fem,u_g);

else

	%First, build elements,grids,loads, etc ... for horizontal, base vertical and vertical model
	fem.m_dv=CreateFemModel(md,'diagnostic_vert');

	if fem.ismacayealpattyn,
		fem.m_dh=CreateFemModel(md,'diagnostic_horiz');
	end
	if fem.ishutter,
		fem.m_ss=CreateFemModel(md,'surface_slope_compute');
		fem.m_dhu=CreateFemModel(md,'diagnostic_hutter');
	end
	if fem.isstokes,
		fem.m_bs=CreateFemModel(md,'bed_slope_compute');
		fem.m_ds=CreateFemModel(md,'diagnostic_stokes');
	end

	%plug inputs in fem (existing velocity)
	if ~isnan(md.vx) & ~isnan(md.vy) & fem.ismacayealpattyn,
		%an input velocity is present in the model, use it to bootstrap the diagnostic core nonlinear solution.
		m_dh=fem.m_dh;
		fem.inputs.velocity=zeros(m_dh.gridset.gsize,1);
		fem.inputs.velocity(1:6:m_dh.gridset.gsize)=md.vx/md.yts;
		fem.inputs.velocity(2:6:m_dh.gridset.gsize)=md.vy/md.yts;
	else
		fem.inputs=struct();
	end

	%compute solution
	u_g=diagnostic3d(md,fem);

	%Load results onto model
	md=Loadresults(md,fem,u_g);
end

%stop timing
t2=clock;
disp(sprintf('\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']));
