function bm = bamgmesh(varargin)
%ICEFRONT - constructor for bamgmesh object
%
%   Usage:
%      bamgmesh = bamgmesh(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	bm.NumVertices=0;
	bm.Vertices=[];

	bm.NumEdges=0;
	bm.Edges=zeros(0,3);

	bm.NumTriangles=0;
	bm.Triangles=[];

	bm.NumQuadrilaterals=0;
	bm.Quadrilaterals=[];

	bm.NumSegments=0;
	bm.Segments=zeros(0,3);
	bm.SegmentsMarkers=[];

	bm.NumVerticesOnGeometricVertex=0;
	bm.VerticesOnGeometricVertex=zeros(0,2);

	bm.NumVerticesOnGeometricEdge=0;
	bm.VerticesOnGeometricEdge=zeros(0,2);

	bm.NumEdgesOnGeometricEdge=0;
	bm.EdgesOnGeometricEdge=zeros(0,2);

	bm.NumCrackedEdges=0;
	bm.CrackedEdges=zeros(0,2);

	bm.NumSubDomains=0;
	bm.SubDomains=zeros(0,4);

	bm.NumSubDomainsFromGeom=0;
	bm.SubDomainsFromGeom=zeros(0,4);

	bm.hVertices=[];

	bm=class(bm,'bamgmesh');

case 1

	bm=bamgmesh;
	object=varargin{1};
	fields=fieldnames(object);
	for i=1:length(fields)
		field=fields{i};
		if isfield(struct(bm),field),
			bm.(field)=object.(field);
		end
	end

otherwise
	error('bamgmesh constructor error message: unknown type of constructor call');
end
