function bg = bamggeom(varargin)
%ICEFRONT - constructor for bamggeom object
%
%   Usage:
%      bamggeom = bamggeom(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	bg.NumVertices=0;
	bg.Vertices=[];

	bg.NumEdges=0;
	bg.Edges=zeros(0,3);

	bg.NumTangentAtEdges=0;
	bg.TangentAtEdges=[];

	bg.NumCorners=0;
	bg.Corners=[];

	bg.NumRequiredVertices=0;
	bg.RequiredVertices=[];

	bg.NumRequiredEdges=0;
	bg.RequiredEdges=[];

	bg.NumCrackedEdges=0;
	bg.CrackedEdges=zeros(0,3);

	bg.hVertices=[];
	bg.MetricVertices=zeros(0,3);
	bg.h1h2VpVertices=[];

	bg.NumSubDomains=0;
	bg.SubDomains=zeros(0,4);

	bg=class(bg,'bamggeom');

case 1

	bg=bamggeom;
	object=varargin{1};
	fields=fieldnames(object);
	for i=1:length(fields)
		field=fields{i};
		if isfield(struct(bg),field),
			bg.(field)=object.(field);
		end
	end

otherwise
	error('bamggeom constructor error message: unknown type of constructor call');
end
