/*!\file:  BamgMesh.h
 */ 

#ifndef BAMGMESH_H_
#define BAMGMESH_H_

#include <mex.h>

struct BamgMesh{

	int     NumTriangles;
	double* Triangles;

	int     NumVertices;
	double* Vertices;

	int     NumEdges;
	double* Edges;

	int     NumSegments;
	double* Segments;
	double* SegmentsMarkers;

	int     NumCrackedEdges;
	double* CrackedEdges;

	int     NumQuadrilaterals;
	double* Quadrilaterals;

	int     NumVerticesOnGeometricVertex;
	double* VerticesOnGeometricVertex;

	int     NumVerticesOnGeometricEdge;
	double* VerticesOnGeometricEdge;

	int     NumEdgesOnGeometricEdge;
	double* EdgesOnGeometricEdge;

	int     NumSubDomains;
	double* SubDomains;

	int     NumSubDomainsFromGeom;
	double* SubDomainsFromGeom;

	double* hVertices;
};

void BamgMeshInit(BamgMesh* bamgmesh);
void BamgMeshWrite(mxArray** bamgmesh_mat,BamgMesh* bamgmesh);

#endif
