/*!\file:  BamgGeom.h
 */ 

#ifndef BAMGGEOM_H_
#define BAMGGEOM_H_

#include <mex.h>

struct BamgGeom{

	int     NumVertices;
	double* Vertices;

	int     NumEdges;
	double* Edges;

	double* hVertices;
	double* MetricVertices;
	double* h1h2VpVertices;

	int     NumTangentAtEdges;
	double* TangentAtEdges;

	int     NumCorners;
	double* Corners;

	int     NumRequiredVertices;
	double* RequiredVertices;

	int     NumRequiredEdges;
	double* RequiredEdges;

	int     NumCrackedEdges;
	double* CrackedEdges;

	int     NumSubDomains;
	double* SubDomains;
};

void BamgGeomInit(BamgGeom* bamggeom);
void BamgGeomWrite(mxArray** bamggeom_mat,BamgGeom* bamggeom);

#endif
