/*\file Bamg.c
 *\brief: bamg module.
 */
#include "./Bamg.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;
	int   i;
	int   lines,cols;
	BamgOpts bamgopts;
	BamgMesh bamgmesh_in,bamgmesh_out;
	BamgGeom bamggeom_in,bamggeom_out;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&BamgUsage);

	/*create bamg geometry input*/
	BamgGeomInit(&bamggeom_in);
	FetchData(&bamggeom_in.NumVertices,mxGetField(BAMGGEOMETRY,0,"NumVertices"));
	FetchData(&bamggeom_in.Vertices,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Vertices"));
	FetchData(&bamggeom_in.NumEdges,mxGetField(BAMGGEOMETRY,0,"NumEdges"));
	FetchData(&bamggeom_in.Edges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"Edges"));
	FetchData(&bamggeom_in.hVertices,&lines,&cols,mxGetField(BAMGGEOMETRY,0,"hVertices"));
	FetchData(&bamggeom_in.NumCrackedEdges,mxGetField(BAMGGEOMETRY,0,"NumCrackedEdges"));
	FetchData(&bamggeom_in.CrackedEdges,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"CrackedEdges"));
	FetchData(&bamggeom_in.NumSubDomains,mxGetField(BAMGGEOMETRY,0,"NumSubDomains"));
	FetchData(&bamggeom_in.SubDomains,NULL,NULL,mxGetField(BAMGGEOMETRY,0,"SubDomains"));
	if (bamggeom_in.hVertices && (cols!=1 || lines!=bamggeom_in.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'hVertices' should be [%i %i]",bamggeom_in.NumVertices,1));}

	/*create bamg mesh input*/
	BamgMeshInit(&bamgmesh_in);
	FetchData(&bamgmesh_in.NumVertices,mxGetField(BAMGMESH,0,"NumVertices"));
	FetchData(&bamgmesh_in.Vertices,NULL,NULL,mxGetField(BAMGMESH,0,"Vertices"));
	FetchData(&bamgmesh_in.NumTriangles,mxGetField(BAMGMESH,0,"NumTriangles"));
	FetchData(&bamgmesh_in.Triangles,NULL,NULL,mxGetField(BAMGMESH,0,"Triangles"));
	FetchData(&bamgmesh_in.hVertices,&lines,&cols,mxGetField(BAMGMESH,0,"hVertices"));
	FetchData(&bamgmesh_in.NumCrackedEdges,mxGetField(BAMGMESH,0,"NumCrackedEdges"));
	FetchData(&bamgmesh_in.CrackedEdges,NULL,NULL,mxGetField(BAMGMESH,0,"CrackedEdges"));
	FetchData(&bamgmesh_in.NumEdges,mxGetField(BAMGMESH,0,"NumEdges"));
	FetchData(&bamgmesh_in.Edges,NULL,NULL,mxGetField(BAMGMESH,0,"Edges"));
	FetchData(&bamgmesh_in.NumEdgesOnGeometricEdge,mxGetField(BAMGMESH,0,"NumEdgesOnGeometricEdge"));
	FetchData(&bamgmesh_in.EdgesOnGeometricEdge,NULL,NULL,mxGetField(BAMGMESH,0,"EdgesOnGeometricEdge"));
	FetchData(&bamgmesh_in.NumVerticesOnGeometricEdge,mxGetField(BAMGMESH,0,"NumVerticesOnGeometricEdge"));
	FetchData(&bamgmesh_in.VerticesOnGeometricEdge,NULL,NULL,mxGetField(BAMGMESH,0,"VerticesOnGeometricEdge"));
	if (bamgmesh_in.hVertices && (cols!=1 || lines!=bamgmesh_in.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'hVertices' should be [%i %i]",bamgmesh_in.NumVertices,1));}

	/*create bamg options input*/
	BamgOptsInit(&bamgopts);
	FetchData(&bamgopts.coef,mxGetField(BAMGOPTIONS,0,"coef"));
	FetchData(&bamgopts.maxsubdiv,mxGetField(BAMGOPTIONS,0,"maxsubdiv"));
	FetchData(&bamgopts.Hessiantype,mxGetField(BAMGOPTIONS,0,"Hessiantype"));
	FetchData(&bamgopts.Metrictype,mxGetField(BAMGOPTIONS,0,"Metrictype"));
	FetchData(&bamgopts.KeepVertices,mxGetField(BAMGOPTIONS,0,"KeepVertices"));
	FetchData(&bamgopts.renumber,mxGetField(BAMGOPTIONS,0,"renumber"));
	FetchData(&bamgopts.power,mxGetField(BAMGOPTIONS,0,"power"));
	FetchData(&bamgopts.errg,mxGetField(BAMGOPTIONS,0,"errg"));
	FetchData(&bamgopts.nbjacobi,mxGetField(BAMGOPTIONS,0,"nbjacobi"));
	FetchData(&bamgopts.NbSmooth,mxGetField(BAMGOPTIONS,0,"NbSmooth"));
	FetchData(&bamgopts.omega,mxGetField(BAMGOPTIONS,0,"omega"));
	FetchData(&bamgopts.maxnbv,mxGetField(BAMGOPTIONS,0,"maxnbv"));
	FetchData(&bamgopts.hmin,mxGetField(BAMGOPTIONS,0,"hmin"));
	FetchData(&bamgopts.hmax,mxGetField(BAMGOPTIONS,0,"hmax"));
	FetchData(&bamgopts.anisomax,mxGetField(BAMGOPTIONS,0,"anisomax"));
	FetchData(&bamgopts.gradation,mxGetField(BAMGOPTIONS,0,"gradation"));
	FetchData(&bamgopts.cutoff,mxGetField(BAMGOPTIONS,0,"cutoff"));
	FetchData(&bamgopts.verbose,mxGetField(BAMGOPTIONS,0,"verbose"));
	FetchData(&bamgopts.splitcorners,mxGetField(BAMGOPTIONS,0,"splitcorners"));
	FetchData(&bamgopts.MaximalAngleOfCorner,mxGetField(BAMGOPTIONS,0,"MaximalAngleOfCorner"));
	FetchData(&bamgopts.metric,&lines,&cols,mxGetField(BAMGOPTIONS,0,"metric"));
	if (bamgopts.metric && (cols!=3 || lines!=bamgmesh_in.NumVertices)){throw ErrorException(__FUNCT__,exprintf("the size of 'metric' should be [%i %i]",bamgmesh_in.NumVertices,3));}
	FetchData(&bamgopts.field,&lines,&bamgopts.numfields,mxGetField(BAMGOPTIONS,0,"field"));
	if (bamgopts.field && lines!=bamgmesh_in.NumVertices){throw ErrorException(__FUNCT__,exprintf("the size of 'field' should be [%i %i]",bamgmesh_in.NumVertices,bamgopts.numfields));}
	FetchData(&bamgopts.err,NULL,&cols,mxGetField(BAMGOPTIONS,0,"err"));
	if (bamgopts.numfields!=0 && cols!=bamgopts.numfields){throw ErrorException(__FUNCT__,exprintf("the size of 'err' should be the same as 'field'"));}
	BamgOptsCheck(&bamgopts);

	/*!Generate internal degree of freedom numbers: */
	Bamgx(&bamgmesh_out,&bamggeom_out,&bamgmesh_in,&bamggeom_in,&bamgopts);

	/*Variables*/
	mxArray*    bamgmesh_mat=NULL;
	mxArray*    pfield=NULL;
	mxArray*    pfield2=NULL;
	int         numfields=23;
	const char* fnames[numfields];
	mwSize      ndim=2;
	mwSize      dimensions[2]={1,1};

	fnames[0] = "NumTriangles";
	fnames[1] = "Triangles";
	fnames[2] = "NumVertices";
	fnames[3] = "Vertices";
	fnames[4] = "NumEdges";
	fnames[5] = "Edges";
	fnames[6] = "NumSegments";
	fnames[7] = "Segments";
	fnames[8] = "SegmentsMarkers";
	fnames[9] = "NumCrackedEdges";
	fnames[10] = "CrackedEdges";
	fnames[11] = "NumQuadrilaterals";
	fnames[12] = "Quadrilaterals";
	fnames[13] = "NumVerticesOnGeometricVertex";
	fnames[14] = "VerticesOnGeometricVertex";
	fnames[15] = "NumVerticesOnGeometricEdge";
	fnames[16] = "VerticesOnGeometricEdge";
	fnames[17] = "NumEdgesOnGeometricEdge";
	fnames[18] = "EdgesOnGeometricEdge";
	fnames[19] = "NumSubDomains";
	fnames[20] = "SubDomains";
	fnames[21] = "NumSubDomainsFromGeom";
	fnames[22] = "SubDomainsFromGeom";

	bamgmesh_mat=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	mxSetField(bamgmesh_mat,0,"NumTriangles",mxCreateDoubleScalar(bamgmesh_out.NumTriangles)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh_out.NumTriangles);
	mxSetPr(pfield,bamgmesh_out.Triangles);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"Triangles",pfield2);

	mxSetField(bamgmesh_mat,0,"NumVertices",mxCreateDoubleScalar(bamgmesh_out.NumVertices)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh_out.NumVertices);
	mxSetPr(pfield,bamgmesh_out.Vertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"Vertices",pfield2);

	mxSetField(bamgmesh_mat,0,"NumEdges",mxCreateDoubleScalar(bamgmesh_out.NumEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh_out.NumEdges);
	mxSetPr(pfield,bamgmesh_out.Edges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"Edges",pfield2);

	mxSetField(bamgmesh_mat,0,"NumSegments",mxCreateDoubleScalar(bamgmesh_out.NumSegments)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamgmesh_out.NumSegments);
	mxSetPr(pfield,bamgmesh_out.Segments);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"Segments",pfield2);

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,1);
	mxSetN(pfield,bamgmesh_out.NumSegments);
	mxSetPr(pfield,bamgmesh_out.SegmentsMarkers);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"SegmentsMarkers",pfield2);

	mxSetField(bamgmesh_mat,0,"NumCrackedEdges",mxCreateDoubleScalar(bamgmesh_out.NumCrackedEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh_out.NumCrackedEdges);
	mxSetPr(pfield,bamgmesh_out.CrackedEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"CrackedEdges",pfield2);

	mxSetField(bamgmesh_mat,0,"NumQuadrilaterals",mxCreateDoubleScalar(bamgmesh_out.NumQuadrilaterals)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,5);
	mxSetN(pfield,bamgmesh_out.NumQuadrilaterals);
	mxSetPr(pfield,bamgmesh_out.Quadrilaterals);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"Quadrilaterals",pfield2);

	mxSetField(bamgmesh_mat,0,"NumVerticesOnGeometricVertex",mxCreateDoubleScalar(bamgmesh_out.NumVerticesOnGeometricVertex)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh_out.NumVerticesOnGeometricVertex);
	mxSetPr(pfield,bamgmesh_out.VerticesOnGeometricVertex);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"VerticesOnGeometricVertex",pfield2);

	mxSetField(bamgmesh_mat,0,"NumVerticesOnGeometricEdge",mxCreateDoubleScalar(bamgmesh_out.NumVerticesOnGeometricEdge)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh_out.NumVerticesOnGeometricEdge);
	mxSetPr(pfield,bamgmesh_out.VerticesOnGeometricEdge);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"VerticesOnGeometricEdge",pfield2);

	mxSetField(bamgmesh_mat,0,"NumEdgesOnGeometricEdge",mxCreateDoubleScalar(bamgmesh_out.NumEdgesOnGeometricEdge)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamgmesh_out.NumEdgesOnGeometricEdge);
	mxSetPr(pfield,bamgmesh_out.EdgesOnGeometricEdge);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"EdgesOnGeometricEdge",pfield2);

	mxSetField(bamgmesh_mat,0,"NumSubDomains",mxCreateDoubleScalar(bamgmesh_out.NumSubDomains)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh_out.NumSubDomains);
	mxSetPr(pfield,bamgmesh_out.SubDomains);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"SubDomains",pfield2);

	mxSetField(bamgmesh_mat,0,"NumSubDomainsFromGeom",mxCreateDoubleScalar(bamgmesh_out.NumSubDomainsFromGeom)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamgmesh_out.NumSubDomainsFromGeom);
	mxSetPr(pfield,bamgmesh_out.SubDomainsFromGeom);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamgmesh_mat,0,"SubDomainsFromGeom",pfield2);

	/*assign output datasets: */
	*BAMGMESHOUT=bamgmesh_mat;

	/*Variables*/
	mxArray*    bamggeom_mat=NULL;
	int         numfields2=14;
	const char* fnames2[numfields];

	fnames[0] = "NumVertices";
	fnames[1] = "Vertices";
	fnames[2] = "NumEdges";
	fnames[3] = "Edges";
	fnames[4] = "NumTangentAtEdges";
	fnames[5] = "TangentAtEdges";
	fnames[6] = "NumRequiredVertices";
	fnames[7] = "RequiredVertices";
	fnames[8] = "NumRequiredEdges";
	fnames[9] = "RequiredEdges";
	fnames[10]= "NumCrackedEdges";
	fnames[11]= "CrackedEdges";
	fnames[12]= "NumEdges";
	fnames[13]= "SubDomains";

	bamggeom_mat=mxCreateStructArray(ndim,dimensions,numfields,fnames);

	mxSetField(bamggeom_mat,0,"NumVertices",mxCreateDoubleScalar(bamggeom_out.NumVertices)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamggeom_out.NumVertices);
	mxSetPr(pfield,bamggeom_out.Vertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamggeom_mat,0,"Vertices",pfield2);

	mxSetField(bamggeom_mat,0,"NumEdges",mxCreateDoubleScalar(bamggeom_out.NumEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,3);
	mxSetN(pfield,bamggeom_out.NumEdges);
	mxSetPr(pfield,bamggeom_out.Edges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamggeom_mat,0,"Edges",pfield2);

	mxSetField(bamggeom_mat,0,"NumTangentAtEdges",mxCreateDoubleScalar(bamggeom_out.NumTangentAtEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamggeom_out.NumTangentAtEdges);
	mxSetPr(pfield,bamggeom_out.TangentAtEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamggeom_mat,0,"TangentAtEdges",pfield2);

	mxSetField(bamggeom_mat,0,"NumRequiredVertices",mxCreateDoubleScalar(bamggeom_out.NumRequiredVertices)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,1);
	mxSetN(pfield,bamggeom_out.NumRequiredVertices);
	mxSetPr(pfield,bamggeom_out.RequiredVertices);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamggeom_mat,0,"RequiredVertices",pfield2);

	mxSetField(bamggeom_mat,0,"NumRequiredEdges",mxCreateDoubleScalar(bamggeom_out.NumRequiredEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,1);
	mxSetN(pfield,bamggeom_out.NumRequiredEdges);
	mxSetPr(pfield,bamggeom_out.RequiredEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamggeom_mat,0,"RequiredEdges",pfield2);

	mxSetField(bamggeom_mat,0,"NumCrackedEdges",mxCreateDoubleScalar(bamggeom_out.NumCrackedEdges)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,2);
	mxSetN(pfield,bamggeom_out.NumCrackedEdges);
	mxSetPr(pfield,bamggeom_out.CrackedEdges);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamggeom_mat,0,"CrackedEdges",pfield2);

	mxSetField(bamggeom_mat,0,"NumSubDomains",mxCreateDoubleScalar(bamggeom_out.NumSubDomains)); 

	pfield=mxCreateDoubleMatrix(0,0,mxREAL);
	mxSetM(pfield,4);
	mxSetN(pfield,bamggeom_out.NumSubDomains);
	mxSetPr(pfield,bamggeom_out.SubDomains);
	mexCallMATLAB(1,&pfield2,1,&pfield,"'");//transpose
	mxSetField(bamggeom_mat,0,"SubDomains",pfield2);

	/*assign output datasets: */
	*BAMGGEOMOUT=bamggeom_mat;

	/*Free ressources: */
	//do not free any fields of bamgmesh or bamggeom as it has been freed in bamgx

	/*end module: */
	MODULEEND();
}

void BamgUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements,vertices,segments,segmentmarkers,metric]=%s(bamgmesh,bamggeom,bamgoptions);\n",__FUNCT__);
	_printf_("\n");
}
