/*!\file: types.h
 * \brief prototypes for types.h
 */ 

#ifndef _TYPES_H_
#define  _TYPES_H_

/*Define abstract type for I/O: */
#ifdef _SERIAL_
#include <mex.h>
typedef const mxArray* ConstDataHandle;  //serially, we are reading data from a matlab array.
typedef mxArray* DataHandle;  
#else 
typedef FILE* ConstDataHandle; //in parallel, we are reading data from a file.
typedef FILE* DataHandle; 
#endif
enum param_type { STRING, INTEGER, STRINGARRAY, DOUBLE, DOUBLEVEC, DOUBLEMAT, PETSCVEC, PETSCMAT };

#endif //ifndef _TYPES_H_
