#include <cstdio>
#include <string.h>
#include <cmath>
#include <time.h>

#include "GeometricalEdge.h"
#include "Geometry.h"

#undef __FUNCT__ 
#define __FUNCT__ "GeometricalEdge"

using namespace std;

namespace bamg {

	/*Constructor/Destructor*/

	/*Methods*/
	/*FUNCTION GeometricalEdge::R1tg{{{1*/
	double GeometricalEdge::R1tg(double theta,R2 & t) const{
		/*Original code from Frederic Hecht <hecht@ann.jussieu.fr> (BAMG v1.01, MeshGeom.cpp/R1tg)*/
		// 1/R of radius of cuvature

		R2 A=v[0]->r,B=v[1]->r;
		double dca,dcb,dcta,dctb;
		double ddca,ddcb,ddcta,ddctb;
		// double t1 = 1 -theta;
		// double t1t1 = t1*t1;
		double tt = theta*theta;
		if ( theta<0){
			throw ErrorException(__FUNCT__,exprintf("theta<0"));
		}
		if ( theta>1){
			throw ErrorException(__FUNCT__,exprintf("theta>1"));
		}
		if (TgA()) 
		 if (TgB()) // interpolation d'hermite
			{ //cb =  theta*theta*(3-2*theta);
			 dcb = 6*theta*(1-theta);
			 ddcb = 6*(1-2*theta);
			 //ca =  1-cb;     
			 dca = -dcb;
			 ddca = -ddcb;

			 // cta = (1-theta)*(1-theta)*theta;
			 dcta =  (3*theta - 4)*theta + 1;
			 ddcta=6*theta-4;

			 //ctb = (theta-1)*theta*theta ;
			 dctb = 3*tt - 2*theta;
			 ddctb = 6*theta-2;
			}
		 else { // 1-t*t, t-t*t, t*t
			 double t = theta;
			 // cb = t*t;
			 dcb = 2*t;
			 ddcb = 2;
			 //ca = 1-cb;
			 dca = -dcb;
			 ddca = -2;
			 // cta= t-cb;
			 dcta = 1-dcb;
			 ddcta = -ddcb;
			 // ctb =0;
			 dctb=0;    
			 ddctb=0;    
		 }    
		else
		 if (TgB()){
			 double t = 1-theta;
			 //ca = t*t;
			 dca = -2*t;
			 ddca = 2;
			 //cb = 1-ca;
			 dcb = -dca;
			 ddcb = -2;
			 //ctb= -t+ca;
			 dctb = 1+dca;
			 ddctb= ddca;
			 //cta=0;    
			 dcta =0;
			 ddcta =0;
		 }
		 else {t=B-A;return 0;} // lagrange P1
		R2 d =  A*dca + B*dcb + tg[0]* dcta + tg[1] * dctb;

		R2 dd =  A*ddca + B*ddcb + tg[0]* ddcta + tg[1] * ddctb;
		double d2=(d,d);
		double sd2 = sqrt(d2);
		t=d;
		if(d2>1.0e-20) {t/=sd2;return Abs(Det(d,dd))/(d2*sd2);}
		else return 0;
	  }
	/*}}}1*/
	/*FUNCTION GeometricalEdge::F{{{1*/
	R2 GeometricalEdge::F(double theta) const{
		/*Original code from Frederic Hecht <hecht@ann.jussieu.fr> (BAMG v1.01, MeshGeom.cpp/F)*/
		// parametrization of the curve edge

	   R2 A=v[0]->r,B=v[1]->r;
		double ca,cb,cta,ctb;
		if ( theta<-1e-12){
			throw ErrorException(__FUNCT__,exprintf("theta<-1e-12"));
		}
		if ( theta>1+1e-12){
			throw ErrorException(__FUNCT__,exprintf("theta>1+1e-12"));
		}
		if (TgA()) 
		 if (TgB()) // interpolation d'hermite
			{ cb =  theta*theta*(3-2*theta);
			 ca =  1-cb;     
			 cta = (1-theta)*(1-theta)*theta;
			 ctb = (theta-1)*theta*theta ;
			}
		 else { // 1-t*t, t-t*t, t*t
			 double t = theta;
			 cb = t*t;
			 ca = 1-cb;
			 cta= t-cb;
			 ctb=0;    
		 }    
		else
		 if (TgB()){
			 double t = 1-theta;
			 ca = t*t;
			 cb = 1-ca;
			 ctb= -t+ca;
			 cta=0;    
		 }
		 else {
			 ca =(1-theta),cb = theta,cta=ctb=0; // lagrange P1
		 }
		return A*ca + B*cb + tg[0]* cta + tg[1] * ctb;
	  }
	/*}}}1*/
	/*FUNCTION GeometricalEdge::Set {{{1*/
	void GeometricalEdge::Set(const GeometricalEdge & rec,const Geometry & Gh ,Geometry & GhNew){ 
		*this = rec;
		v[0] = GhNew.vertices + Gh.Number(v[0]);    
		v[1] = GhNew.vertices + Gh.Number(v[1]); 
		if (Adj[0]) Adj[0] =  GhNew.edges + Gh.Number(Adj[0]);     
		if (Adj[1]) Adj[1] =  GhNew.edges + Gh.Number(Adj[1]);     
	}
	/*}}}*/

}
