#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "CrackedEdge.h"

#undef __FUNCT__ 
#define __FUNCT__ "CrackedTriangle"

namespace bamg {

	/*Constructors/Destructors*/

	/*Methods*/
	/*FUNCTION CrackedEdge::CrackedTriangle::Crack{{{1*/
	void CrackedEdge::CrackedTriangle::Crack(){ 
		Triangle & T(*t); 
		int i0=VerticesOfTriangularEdge[i][0];
		int i1=VerticesOfTriangularEdge[i][0];
		if (!New[0] && !New[1]){
			throw ErrorException(__FUNCT__,exprintf("!New[0] && !New[1]"));
		}
		T(i0) = New[0];
		T(i1) = New[1];
	} 
	/*}}}*/
	/*FUNCTION CrackedEdge::CrackedTriangle::UnCrack {{{1*/
	void CrackedEdge::CrackedTriangle::UnCrack(){ 
		Triangle & T(*t); 
		int i0=VerticesOfTriangularEdge[i][0];
		int i1=VerticesOfTriangularEdge[i][0];
		if (!New[0] && !New[1]){
			throw ErrorException(__FUNCT__,exprintf("!New[0] && !New[1]"));
		}
		T(i0) = TheVertex(T(i0));
		T(i1) = TheVertex(T(i1));
	} 
	/*}}}*/
	/*FUNCTION CrackedEdge::CrackedTriangle::Set {{{1*/
	void CrackedEdge::CrackedTriangle::Set(){
		TriangleAdjacent ta( FindTriangleAdjacent(*edge));
		t = ta;
		i = ta;

		New[0] = ta.EdgeVertex(0);
		New[1] = ta.EdgeVertex(1);
		// warning the ref 
	} 
	/*}}}*/

} 
