function md=meshyamsrecreateriftsegments(md)

	%recreate rift segments: just used for yams. temporaroy routine.
	pos_record=[];
	if md.numrifts,
		for i=1:md.numrifts,
			rift=md.rifts(i);

			%closed rifts first:
			if length(rift.tips)==2,

				%find tip1 and tip2 for this rift, in the new mesh created by yams.
				pos=find_point(md.x(md.segments(:,1)),md.y(md.segments(:,1)),rift.tip1coordinates(1),rift.tip1coordinates(2));
				tip1=md.segments(pos,1);
				pos=find_point(md.x(md.segments(:,1)),md.y(md.segments(:,1)),rift.tip2coordinates(1),rift.tip2coordinates(2));
				tip2=md.segments(pos,1);

				%start from tip1, and build segments of this rift. 
				pos=find_point(md.x(md.segments(:,1)),md.y(md.segments(:,1)),rift.tip1coordinates(1),rift.tip1coordinates(2));
				pos_record=[pos_record; pos];
				riftsegs=md.segments(pos,:);
				while 1,
					A=riftsegs(end,1); B=riftsegs(end,2); el=riftsegs(end,3);
					%find other segment that holds B.
					pos=find(md.segments(:,1)==B);
					pos_record=[pos_record; pos];
					riftsegs=[riftsegs; md.segments(pos,:)];
					if riftsegs(end,2)==tip1, 
						break;
					end
				end
				md.rifts(i).segments=riftsegs;
				md.rifts(i).tips=[tip1 tip2];

			else
				%ok, this is a rift that opens up to the domain outline.  One tip is going to be 
				%double, the other one, single. We are going to start from the single tip, towards the two 
				%other doubles

				%find tip1 and tip2 for this rift, in the new mesh created by yams.
				pos1=find_point(md.x(md.segments(:,1)),md.y(md.segments(:,1)),rift.tip1coordinates(1),rift.tip1coordinates(2));
				tip1=md.segments(pos1,1);
				pos2=find_point(md.x(md.segments(:,1)),md.y(md.segments(:,1)),rift.tip2coordinates(1),rift.tip2coordinates(2));
				tip2=md.segments(pos2,1);
				if length(tip1)==2,
					%swap.
					temp=tip1; tip1=tip2; tip2=temp;
					temp=pos1; pos1=pos2; pos2=temp;
					pos=pos1;
				else
					pos=pos1;
				end

				pos_record=[pos_record; pos];
				riftsegs=md.segments(pos,:);
				while 1,
					A=riftsegs(end,1); B=riftsegs(end,2); el=riftsegs(end,3);
					%find other segment that holds B.
					pos=find(md.segments(:,1)==B);
					pos_record=[pos_record; pos];
					riftsegs=[riftsegs; md.segments(pos,:)];
					if ((riftsegs(end,2)==tip2(1)) | (riftsegs(end,2)==tip2(2))), 
						%figure out which tip we reached
						if riftsegs(end,2)==tip2(1), index=2; else index=1; end
						break;
					end
				end

				%ok, now, we start from the other tip2, towards tip1
				pos=pos2(index);
				pos_record=[pos_record; pos];
				riftsegs=[riftsegs; md.segments(pos,:)];
				while 1,
					A=riftsegs(end,1); B=riftsegs(end,2); el=riftsegs(end,3);
					%find other segment that holds B.
					pos=find(md.segments(:,1)==B);
					pos_record=[pos_record; pos];
					riftsegs=[riftsegs; md.segments(pos,:)];
					if riftsegs(end,2)==tip1, 
						break;
					end
				end
				md.rifts(i).segments=riftsegs;
				md.rifts(i).tips=[tip1 tip2(1) tip2(2)];

			end
		end
	end
	%take out rift segments from segments
	md.segments(pos_record,:)=[];
