#ifndef _QUALITE_H_
#define _QUALITE_H_

#include "../meshtype.h"
#include "../objects/Vertex.h"

namespace bamg {

	inline double qualite(const Vertex &va,const Vertex &vb,const Vertex &vc){
		double ret; 
		I2 ia=va,ib=vb,ic=vc;
		I2 ab=ib-ia,bc=ic-ib,ac=ic-ia;
		Icoor2 deta=Det(ab,ac);
		if (deta <=0) ret = -1;
		else {
			double a = sqrt((double) (ac,ac)),
					 b = sqrt((double) (bc,bc)),
					 c = sqrt((double) (ab,ab)),
					 p = a+b+c;
			double h= Max(Max(a,b),c),ro=deta/p;
			ret = ro/h;
		}
		return ret;
	}

}
#endif
