#ifndef _THEVERTEX_H_
#define _THEVERTEX_H_

#include "../meshtype.h"
#include "../objects/Vertex.h"

namespace bamg {

	inline Vertex* TheVertex(Vertex * a){// for remove crak in mesh 
		/*Original code from Frederic Hecht <hecht@ann.jussieu.fr> (BAMG v1.01, Mesh2.cpp)*/

		// give a unique vertex with smallest number
		// in case on crack in mesh 
		Vertex * r(a), *rr;
		Triangle * t = a->t;
		int i = a->vint;
		TriangleAdjacent ta(t,EdgesVertexTriangle[i][0]); // Previous edge
		if (!t || i<0 || i>=3){
			throw ErrorException(__FUNCT__,exprintf("!t || i<0 !! i>=3"));
		}
		if ( a!=(*t)(i)){
			throw ErrorException(__FUNCT__,exprintf("a!=(*t)(i)"));
		}
		int k=0;
		do { // turn around vertex in direct sens (trigo)
			k++;
			if (k>=20000){
				throw ErrorException(__FUNCT__,exprintf("k>=20000"));
			}
			//  in no crack => ta.EdgeVertex(1) == a
			if ((rr=ta.EdgeVertex(0)) < r) r = rr;
			ta = ta.Adj();
			if ((rr=ta.EdgeVertex(1)) < r) r =rr;
			--ta;
		} while (t != (Triangle*) ta);  
		return r;
	}

}
#endif
