
#include "../BamgObjects.h"

#undef __FUNCT__ 
#define __FUNCT__ "SetOfEdges4"

using namespace std;
namespace bamg {

	/*Constructor*/
	/*FUNCTION  SetOfEdges4::SetOfEdges4(long mmx,long nnx){{{1*/
	SetOfEdges4::SetOfEdges4(long mmx,long nnx){

		/*Intermediary*/
		int i;

		//initialize fields
		nx   =nnx;   //number of vertices
		nbax =mmx; // 3 * number of triangles
		NbOfEdges=0;
		head = new long [nx];
		Edges= new IntEdge[nbax];

		//initialize head (-1 everywhere)
		i=nx;
		while (i--) head[i]=-1;
	}
	/*}}}1*/

	/*Methods*/ 
	/*FUNCTION  SetOfEdges4::find {{{1*/
	long SetOfEdges4::find(long ii,long jj) { 

		/*Intermediary*/
		int n;

		//check that head is not empty
		if (head==NULL) {
			throw ErrorException(__FUNCT__,exprintf("SetOfEdges4::add no head is NULL (How come?)"));
		}

		//get n from h (usually h=ii)
		n=head[Abs(ii)%nx];

		//go through the existing edges that holds h (=ii) and return position in Edge
		while (n >= 0){

			//if the edge ii jj is already in Edges, return n
			if (ii == Edges[n].i && jj == Edges[n].j) return n;

			//else go to next edge that holds ii
			else n = Edges[n].next;
		}

		//if we reach this point, the edge does not exist return -1
		return -1;
	}
	/*}}}1*/
	/*FUNCTION  SetOfEdges4::add{{{1*/
	long SetOfEdges4::add(long ii,long jj) {

		/*Intermediary*/
		int h,n;

		//check that head is not empty
		if (head==NULL) {
			throw ErrorException(__FUNCT__,exprintf("SetOfEdges4::add no head is NULL (How come?)"));
		}

		//get n from h (usually h=ii)
		n=head[h=Abs(ii)%nx];

		//go through the existing edges that holds h (=ii) and check that 
		//the edge ii jj is not already in Edge
		while (n >= 0){

			//if the edge ii jj is already in Edges, return n
			if (ii == Edges[n].i && jj == Edges[n].j) return n;

			//else go to next edge that holds ii
			else n = Edges[n].next;
		}

		//check that nbax <=NbOfEdges
		if (nbax <=NbOfEdges ) {
			throw ErrorException(__FUNCT__,exprintf("SetOfEdges4::add overflow: NbOfEdges=%i > nbax=%i",NbOfEdges,nbax));
		}

		//update chain
		Edges[NbOfEdges].i=ii;
		Edges[NbOfEdges].j=jj;
		Edges[NbOfEdges].next= head[h];
		head[h] = NbOfEdges;
		return NbOfEdges ++;
	}
	/*}}}1*/
}
