#ifndef _CRACKEDEDGE_H_
#define _CRACKEDEDGE_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../meshtype.h"
#include "Vertex.h"
#include "TriangleAdjacent.h"
#include "Edge.h"
#include "Triangle.h"
#include "../shared/TheVertex.h"
#include "../shared/FindTriangleAdjacent.h"

namespace bamg {

	//classes
	class Triangles;

	class CrackedEdge {

		friend class Triangles;

		class CrackedTriangle {
			friend class Triangles;
			friend class CrackedEdge;
			Triangle* t; // edge of triangle t
			int i;       //  edge number of in triangle
			Edge *edge;  // the  2 edge 
			Vertex *New[2]; // new vertex number 

			//Constructors
			CrackedTriangle() : t(0),i(0),edge(0) { New[0]=New[1]=0;} 
			CrackedTriangle(Edge * a) : t(0),i(0),edge(a) { New[0]=New[1]=0;} 

			//Methods
			void Crack(){ 
				Triangle & T(*t); 
				int i0=VerticesOfTriangularEdge[i][0];
				int i1=VerticesOfTriangularEdge[i][0];
				if (!New[0] && !New[1]){
					throw ErrorException(__FUNCT__,exprintf("!New[0] && !New[1]"));
				}
				T(i0) = New[0];
				T(i1) = New[1];
			}    
			void UnCrack(){ 
				Triangle & T(*t); 
				int i0=VerticesOfTriangularEdge[i][0];
				int i1=VerticesOfTriangularEdge[i][0];
				if (!New[0] && !New[1]){
					throw ErrorException(__FUNCT__,exprintf("!New[0] && !New[1]"));
				}
				T(i0) = TheVertex(T(i0));
				T(i1) = TheVertex(T(i1));
			} 
			void Set() {
				TriangleAdjacent ta ( FindTriangleAdjacent(*edge));
				t = ta;
				i = ta;

				New[0] = ta.EdgeVertex(0);
				New[1] = ta.EdgeVertex(1);
				// warning the ref 
			}    
		};

		public:  
			CrackedTriangle a,b; 

			//Constructors
			CrackedEdge() :a(),b() {}
			CrackedEdge(Edge * start, long  i,long j) : a(start+i),b(start+j) {};
			CrackedEdge(Edge * e0, Edge * e1 ) : a(e0),b(e1) {};

			//Methods
			void Crack() { a.Crack(); b.Crack();}
			void UnCrack() { a.UnCrack(); b.UnCrack();}
			void Set() { a.Set(), b.Set();}
	};

}
#endif
