#ifndef _VERTEXONGEOM_H_
#define _VERTEXONGEOM_H_

#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/macros.h"
#include "../../toolkits/toolkits.h"

#include "../meshtype.h"
#include "Vertex.h"
#include "GeometricalVertex.h"
#include "GeometricalEdge.h"

namespace bamg {

	//classes
	class Triangles;

	class VertexOnGeom{

		public:

			Vertex* mv;
			double abscisse;  
			union{ 
				GeometricalVertex * gv; // if abscisse <0; 
				GeometricalEdge * ge;  // if abscisse in [0..1]
			};

			//Constructors/Destructors
			VertexOnGeom(): mv(0),abscisse(0){gv=0;} 
			VertexOnGeom(Vertex & m,GeometricalVertex &g) : mv(&m),abscisse(-1){gv=&g;}
			VertexOnGeom(Vertex & m,GeometricalEdge &g,double s) : mv(&m),abscisse(s){ge=&g;}

			//Operators
			operator Vertex * () const  {return mv;}
			operator GeometricalVertex * () const  {return gv;}
			operator GeometricalEdge * () const  {return ge;}
			operator const double & () const {return abscisse;}

			//Methods
			int  OnGeomVertex()const {return this? abscisse <0 :0;}
			int  OnGeomEdge() const {return this? abscisse >=0 :0;}
			int  IsRequiredVertex(){ return this? (( abscisse<0 ? (gv?gv->Required():0):0 )) : 0;}
			void SetOn(){mv->onGeometry=this;mv->vint=IsVertexOnGeom;}

			//Inline methods
			inline void Set(const Triangles &,long,Triangles &);
			inline void Set(const VertexOnGeom&,const Triangles &,Triangles &);  

	};

}
#endif
